/*
 * Decompiled with CFR 0.152.
 */
package adalid.jee2;

import adalid.commons.bundles.Bundle;
import adalid.commons.util.StrUtils;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SpecialPage {
    private static final Logger logger = Logger.getLogger(SpecialPage.class);
    private static final String CODE = SpecialPage.class.getSimpleName();
    private static final String DEFAULT_VIEW_FOLDER = "/faces/views/custom-made/";
    private static final String DEFAULT_VIEW_EXTENSION = ".xhtml";
    private static int next;
    private final String _code;
    private final String _view;
    private String _helpDocument;
    private String _helpFileName;
    private String _helpFileBookmark;
    private String _iconClass;
    private Long _id;
    private final Map<Locale, String> _localizedLabel = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedBreadcrumbLabel = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedDetailLabel = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedMasterLabel = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedShortDescription = new LinkedHashMap<Locale, String>();

    public static SpecialPage of(String code) {
        return new SpecialPage(code, null);
    }

    public static SpecialPage of(String code, String view) {
        return new SpecialPage(code, view);
    }

    private SpecialPage(String code, String view) {
        this._code = StringUtils.defaultIfBlank((String)code, (String)(CODE + ++next));
        this._view = StringUtils.defaultIfBlank((String)view, (String)(DEFAULT_VIEW_FOLDER + this._code + DEFAULT_VIEW_EXTENSION));
    }

    public static String view(String partialView) {
        return DEFAULT_VIEW_FOLDER + partialView + DEFAULT_VIEW_EXTENSION;
    }

    public String getCode() {
        return this._code;
    }

    public String getView() {
        return this._view;
    }

    public boolean isExternalView() {
        return !this.isInternalView();
    }

    public boolean isInternalView() {
        return this._view.startsWith("/");
    }

    public String getHelpDocument() {
        return this._helpDocument;
    }

    public void setHelpDocument(String document) {
        if (document != null && document.matches("^((?:<iframe\\b[^>]*)\\bsrc=\"(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]\".*(?:(?:\\/>)|(?:>.*?<\\/iframe>))|(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])$")) {
            this._helpDocument = document;
        } else {
            this._helpDocument = null;
            logger.warn((Object)("\"" + document + "\" is not a valid help document; " + this._code + " help document has been annulled "));
        }
    }

    public String getHelpFileName() {
        return this._helpFileName;
    }

    public void setHelpFileName(String fileName) {
        this._helpFileName = fileName;
    }

    public String getHelpFileBookmark() {
        return this._helpFileBookmark;
    }

    public void setHelpFileBookmark(String bookmark) {
        this._helpFileBookmark = bookmark;
    }

    public String getIconClass() {
        return this._iconClass;
    }

    public void setIconClass(String iconClass) {
        this._iconClass = iconClass;
    }

    public Long getId() {
        return this._id;
    }

    public void setId(Long id) {
        this._id = id;
    }

    public String getNumericKeyCode() {
        return this._id == null ? StrUtils.getLongNumericKeyCode("SPECIAL_PAGE_" + this._code) : this._id.toString();
    }

    public String getDefaultLabel() {
        return this.getLocalizedLabel(null);
    }

    public void setDefaultLabel(String defaultLabel) {
        this.setLocalizedLabel(null, defaultLabel);
    }

    public String getLocalizedLabel(Locale locale) {
        Locale l = this.localeKey(locale);
        return this._localizedLabel.get(l);
    }

    public void setLocalizedLabel(Locale locale, String localizedLabel) {
        Locale l = this.localeKey(locale);
        if (localizedLabel == null) {
            this._localizedLabel.remove(l);
        } else {
            this._localizedLabel.put(l, localizedLabel);
        }
    }

    public String getDefaultBreadcrumbLabel() {
        return this.getLocalizedBreadcrumbLabel(null);
    }

    public void setDefaultBreadcrumbLabel(String defaultBreadcrumbLabel) {
        this.setLocalizedBreadcrumbLabel(null, defaultBreadcrumbLabel);
    }

    public String getLocalizedBreadcrumbLabel(Locale locale) {
        Locale l = this.localeKey(locale);
        return this._localizedBreadcrumbLabel.get(l);
    }

    public void setLocalizedBreadcrumbLabel(Locale locale, String localizedBreadcrumbLabel) {
        Locale l = this.localeKey(locale);
        if (localizedBreadcrumbLabel == null) {
            this._localizedBreadcrumbLabel.remove(l);
        } else {
            this._localizedBreadcrumbLabel.put(l, localizedBreadcrumbLabel);
        }
    }

    public String getDefaultDetailLabel() {
        return this.getLocalizedDetailLabel(null);
    }

    public void setDefaultDetailLabel(String defaultDetailLabel) {
        this.setLocalizedDetailLabel(null, defaultDetailLabel);
    }

    public String getLocalizedDetailLabel(Locale locale) {
        Locale l = this.localeKey(locale);
        return this._localizedDetailLabel.get(l);
    }

    public void setLocalizedDetailLabel(Locale locale, String localizedDetailLabel) {
        Locale l = this.localeKey(locale);
        if (localizedDetailLabel == null) {
            this._localizedDetailLabel.remove(l);
        } else {
            this._localizedDetailLabel.put(l, localizedDetailLabel);
        }
    }

    public String getDefaultMasterLabel() {
        return this.getLocalizedMasterLabel(null);
    }

    public void setDefaultMasterLabel(String defaultMasterLabel) {
        this.setLocalizedMasterLabel(null, defaultMasterLabel);
    }

    public String getLocalizedMasterLabel(Locale locale) {
        Locale l = this.localeKey(locale);
        return this._localizedMasterLabel.get(l);
    }

    public void setLocalizedMasterLabel(Locale locale, String localizedMasterLabel) {
        Locale l = this.localeKey(locale);
        if (localizedMasterLabel == null) {
            this._localizedMasterLabel.remove(l);
        } else {
            this._localizedMasterLabel.put(l, localizedMasterLabel);
        }
    }

    public String getDefaultShortDescription() {
        return this.getLocalizedShortDescription(null);
    }

    public void setDefaultShortDescription(String defaultShortDescription) {
        this.setLocalizedShortDescription(null, defaultShortDescription);
    }

    public String getLocalizedShortDescription(Locale locale) {
        Locale l = this.localeKey(locale);
        return this._localizedShortDescription.get(l);
    }

    public void setLocalizedShortDescription(Locale locale, String localizedShortDescription) {
        Locale l = this.localeKey(locale);
        if (localizedShortDescription == null) {
            this._localizedShortDescription.remove(l);
        } else {
            this._localizedShortDescription.put(l, localizedShortDescription);
        }
    }

    private Locale localeKey(Locale locale) {
        return locale == null ? Bundle.getLocale() : locale;
    }
}

