/*
 * Decompiled with CFR 0.152.
 */
package adalid.jee2.bundles;

import adalid.commons.bundles.Bundle;
import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.StrUtils;
import adalid.commons.util.ThrowableUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class BundleAbstracto {
    private static final Logger logger = Logger.getLogger(BundleAbstracto.class);
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String TEMP_DIR = USER_DIR + FILE_SEP + "resources" + FILE_SEP + "velocity" + FILE_SEP + "templates" + FILE_SEP + "zymurgy";
    private final String baseName = this.getClass().getCanonicalName();

    abstract Locale[] getSupportedLocales();

    abstract Map<Locale, ResourceBundle> bundles();

    abstract Map<Locale, Set<String>> bundleKeys();

    abstract Map<Locale, List<String>> bundleRows();

    abstract Map<Locale, Locale> locales();

    abstract Set<String> warnings();

    abstract Set<String> errors();

    BundleAbstracto(boolean load) {
        if (load) {
            this.load();
        }
    }

    private void load() {
        Locale[] supportedLocales;
        logger.trace((Object)this.baseName);
        for (Locale locale : supportedLocales = this.getSupportedLocales()) {
            ResourceBundle bundle = this.putBundle(locale);
            if (bundle == null) continue;
            Locale localePlus = new Locale(locale.getLanguage(), locale.getCountry(), "PLUS");
            ResourceBundle bundlePlus = this.putBundle(localePlus);
            if (bundlePlus != null) {
                this.locales().put(locale, localePlus);
            }
            this.putBundleKeys(locale);
            this.putBundleRows(locale);
        }
        int n = supportedLocales.length;
        if (n > 1) {
            for (int i = 0; i < n; ++i) {
                Locale loc1 = supportedLocales[i];
                Set<String> set1 = this.bundleKeys().get(loc1);
                for (int j = i + 1; j < n; ++j) {
                    Locale loc2 = supportedLocales[j];
                    Set<String> set2 = this.bundleKeys().get(loc2);
                    if (set2.equals(set1)) continue;
                    this.warn("the keySet of " + this.baseName + "." + loc2 + " is not equal to the keySet of " + this.baseName + "." + loc1);
                }
            }
        }
    }

    private ResourceBundle putBundle(Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.baseName, locale);
            this.bundles().put(locale, bundle);
            return bundle;
        }
        catch (Exception ex) {
            this.error(ex.getClass().getSimpleName() + "@" + this.baseName + "." + locale);
            this.error(ThrowableUtils.getString(ex));
            return null;
        }
    }

    private void warn(String message) {
        this.warnings().add(message);
    }

    private void error(String message) {
        this.errors().add(message);
    }

    private void putBundleKeys(Locale locale) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        this.bundleKeys().put(locale, keys);
        this.addLocaleKeys(keys, locale);
        Locale localePlus = this.getLocalePlus(locale);
        if (localePlus != null) {
            this.addLocaleKeys(keys, localePlus);
        }
    }

    private void addLocaleKeys(Set<String> keys, Locale locale) {
        Set<String> resourceBundleKeys = PropertiesHandler.getResourceBundleKeys(this.baseName, locale);
        if (resourceBundleKeys != null) {
            keys.addAll(resourceBundleKeys);
        }
    }

    private void putBundleRows(Locale locale) {
        ArrayList<String> rows = new ArrayList<String>();
        this.bundleRows().put(locale, rows);
        this.addLocaleRows(rows, locale);
        Locale localePlus = this.getLocalePlus(locale);
        if (localePlus != null) {
            this.addLocaleRows(rows, localePlus);
        }
    }

    private void addLocaleRows(List<String> rows, Locale locale) {
        List<String> resourceBundleRows = PropertiesHandler.getResourceBundleRows(this.baseName, locale);
        if (resourceBundleRows != null) {
            rows.addAll(resourceBundleRows);
        }
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Set<String> getKeys() {
        return this.getKeys(Bundle.getLocale());
    }

    public Set<String> getKeys(Locale locale) {
        ResourceBundle bundle = this.getBundle(locale);
        return bundle == null ? null : this.bundleKeys().get(locale);
    }

    public List<String> getRows() {
        return this.getRows(Bundle.getLocale());
    }

    public List<String> getRows(Locale locale) {
        ResourceBundle bundle = this.getBundle(locale);
        return bundle == null ? null : this.bundleRows().get(locale);
    }

    public File getRowsTemplate() {
        return this.getRowsTemplate(Bundle.getLocale());
    }

    public File getRowsTemplate(Locale locale) {
        File dir = new File(TEMP_DIR);
        File template = new File(dir, StrUtils.getRandomString());
        List<String> rows = this.getRows(locale);
        try {
            FileUtils.forceMkdir((File)dir);
            FileUtils.writeLines((File)template, rows);
            return template;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public String getTemplatePath(File template) {
        if (template == null) {
            return null;
        }
        String path = template.getPath();
        String relativePath = StringUtils.substringAfter((String)path, (String)(FILE_SEP + "velocity" + FILE_SEP));
        return relativePath.replace(FILE_SEP, "/");
    }

    public boolean deleteQuietly(File template) {
        return template != null && FileUtils.deleteQuietly((File)template);
    }

    public String getString(String key) {
        return this.getString(key, Bundle.getLocale());
    }

    public String getString(String key, Locale locale) {
        if (key == null || locale == null) {
            return "";
        }
        String string = this.getString(key, this.getBundle(this.getLocalePlus(locale)));
        return string.isEmpty() ? this.getString(key, this.getBundle(locale)) : string;
    }

    private String getString(String key, ResourceBundle bundle) {
        if (bundle != null) {
            try {
                String string = bundle.getString(key);
                return StringUtils.trimToEmpty((String)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    private ResourceBundle getBundle(Locale locale) {
        return locale == null ? null : this.bundles().get(locale);
    }

    private Locale getLocalePlus(Locale locale) {
        return locale == null ? null : this.locales().get(locale);
    }

    public Set<String> getWarnings() {
        return this.warnings();
    }

    public Set<String> getErrors() {
        return this.errors();
    }
}

