/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.io;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;

public class RegexPathFilter
implements IOFileFilter {
    private static final String OS_NAME = System.getProperty("os.name");
    private static final boolean WINDOWS = StringUtils.containsIgnoreCase((String)OS_NAME, (String)"windows");
    private static final String separator = System.getProperty("file.separator");
    public static final String SEPARATOR = separator.equals("\\") ? "\\\\" : "\\" + separator;
    private final Pattern pattern;

    public RegexPathFilter(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern");
        }
        this.pattern = WINDOWS ? Pattern.compile(pattern, 2) : Pattern.compile(pattern);
    }

    public boolean accept(File dir) {
        return this.pattern.matcher(dir.getPath()).matches();
    }

    public boolean accept(File dir, String name) {
        return this.accept(new File(dir, name));
    }
}

