/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.io;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SmallFile {
    public static final Charset WINDOWS_CHARSET = Charset.forName("windows-1252");
    public static final Charset[] DEFAULT_CHARSETS = new Charset[]{StandardCharsets.UTF_8, WINDOWS_CHARSET};
    private String _name;
    private String _extension;
    private Path _path;
    private Charset[] _charsets;
    private Charset _charset;
    private List<String> _lines;

    public SmallFile(String path) {
        this.init(path, DEFAULT_CHARSETS);
    }

    public SmallFile(String path, Charset[] charsets) {
        this.init(path, charsets);
    }

    private void init(String path, Charset[] charsets) {
        this._name = path;
        this._extension = StringUtils.trimToEmpty((String)StringUtils.substringAfterLast((String)path, (String)"."));
        this._path = Paths.get(path, new String[0]);
        this._charsets = charsets;
    }

    public List<String> read() {
        Charset[] charsets = this._charsets == null ? DEFAULT_CHARSETS : this._charsets;
        this._charset = null;
        for (Charset cs : charsets) {
            try {
                this._lines = Files.readAllLines(this._path, cs);
                this._charset = cs;
                return this._lines;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public String getName() {
        return this._name;
    }

    public String getExtension() {
        return this._extension;
    }

    public Path getPath() {
        return this._path;
    }

    public Charset[] getCharsets() {
        return this._charsets;
    }

    public Charset getCharset() {
        return this._charset;
    }

    public List<String> getLines() {
        return this._lines;
    }

    public boolean isEmpty() {
        return this._lines == null || this._lines.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }
}

