/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.meta.sql;

import adalid.util.meta.sql.TemplateBean;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PlatformBean {
    private static final Logger logger = Logger.getLogger(PlatformBean.class);
    private final String _name;
    private final File _propertiesFile;
    private final Map<String, TemplateBean> _templates;

    public PlatformBean(String name, File propertiesFile) {
        this._name = name;
        this._propertiesFile = propertiesFile;
        this._templates = new TreeMap<String, TemplateBean>();
    }

    public String getName() {
        return this._name;
    }

    public File getPropertiesFile() {
        return this._propertiesFile;
    }

    public Map<String, TemplateBean> getTemplatesMap() {
        return this._templates;
    }

    public void add(TemplateBean template) {
        String path = template.getPropertiesFile().getPath();
        if (StringUtils.isBlank((String)path)) {
            String text = "a null path template will not be added to platform " + this._name;
            logger.error((Object)text);
        } else if (this._templates.containsKey(path)) {
            String text = "template " + path + " already added to platform " + this._name;
            logger.error((Object)text);
        } else {
            this._templates.put(path, template);
        }
    }
}

