/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql;

import adalid.util.sql.SqlArtifact;
import adalid.util.sql.SqlColumn;
import adalid.util.sql.SqlIndexColumn;
import adalid.util.sql.SqlTable;
import adalid.util.sql.SqlUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SqlIndex
extends SqlArtifact {
    private static final Logger logger = Logger.getLogger(SqlIndex.class);
    private final SqlTable _table;
    private int _position;
    private boolean _unique;
    private SqlIndexColumn _lastIndexColumn;
    private final Map<String, SqlIndexColumn> _columns = new LinkedHashMap<String, SqlIndexColumn>();

    public SqlIndex(SqlTable table) {
        this._table = table;
    }

    public SqlTable getTable() {
        return this._table;
    }

    public int getPosition() {
        return this._position;
    }

    void setPosition(int position) {
        this._position = position;
    }

    public boolean isUnique() {
        return this._unique;
    }

    void setUnique(boolean unique) {
        this._unique = unique;
    }

    public Map<String, SqlIndexColumn> getColumnsMap() {
        return this._columns;
    }

    public Collection<SqlIndexColumn> getColumns() {
        return this._columns.values();
    }

    public String getQualifiedName() {
        return this.getTable().getName() + "." + this.getName();
    }

    public boolean isSingleColumnIndex() {
        return this._lastIndexColumn != null && this._columns.size() == 1;
    }

    public SqlColumn getSingleColumn() {
        return !this.isSingleColumnIndex() ? null : this._lastIndexColumn.getColumn();
    }

    public String getSingleColumnOption() {
        return !this.isSingleColumnIndex() ? null : this._lastIndexColumn.getOption();
    }

    void add(SqlIndexColumn column) {
        String name = column.getName();
        if (StringUtils.isBlank((String)name)) {
            String text = "a null name column will not be added to index " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else if (this._columns.containsKey(name)) {
            String text = "column " + name + " already added to index " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else {
            this._lastIndexColumn = column;
            this._columns.put(name, column);
        }
    }
}

