/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql;

import adalid.util.sql.SqlArtifact;
import adalid.util.sql.SqlRoutineParameter;
import adalid.util.sql.SqlTable;
import adalid.util.sql.SqlUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SqlRoutine
extends SqlArtifact {
    private static final Logger logger = Logger.getLogger(SqlRoutine.class);
    private final SqlTable _table;
    private int _position;
    private String _operationType;
    private final Map<String, SqlRoutineParameter> _parameters = new LinkedHashMap<String, SqlRoutineParameter>();
    private int parameters;

    public SqlRoutine(SqlTable table) {
        this._table = table;
    }

    public SqlTable getTable() {
        return this._table;
    }

    public int getPosition() {
        return this._position;
    }

    void setPosition(int position) {
        this._position = position;
    }

    public String getOperationType() {
        return this._operationType;
    }

    public void setOperationType(String operationType) {
        this._operationType = operationType;
    }

    public Map<String, SqlRoutineParameter> getParametersMap() {
        return this._parameters;
    }

    public Collection<SqlRoutineParameter> getParameters() {
        return this._parameters.values();
    }

    public String getQualifiedName() {
        return this.getTable().getName() + "." + this.getName();
    }

    void add(SqlRoutineParameter parameter) {
        parameter.setPosition(++this.parameters);
        String name = parameter.getName();
        if (StringUtils.isBlank((String)name)) {
            String text = "a null name parameter will not be added to routine " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else if (this._parameters.containsKey(name)) {
            String text = "parameter " + name + " already added to routine " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else {
            this._parameters.put(name, parameter);
        }
    }
}

