/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql;

import adalid.util.sql.SqlArtifact;
import adalid.util.sql.SqlTabColumn;
import adalid.util.sql.SqlTable;
import adalid.util.sql.SqlUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SqlTab
extends SqlArtifact {
    private static final Logger logger = Logger.getLogger(SqlTab.class);
    private final SqlTable _table;
    private int _position;
    private String _defaultLabel;
    private final Map<String, SqlTabColumn> _columns = new LinkedHashMap<String, SqlTabColumn>();
    private int columns;

    public SqlTab(SqlTable table) {
        this._table = table;
    }

    public SqlTable getTable() {
        return this._table;
    }

    public int getPosition() {
        return this._position;
    }

    void setPosition(int position) {
        this._position = position;
    }

    public String getDefaultLabel() {
        return this._defaultLabel;
    }

    void setDefaultLabel(String defaultLabel) {
        this._defaultLabel = defaultLabel;
    }

    public Map<String, SqlTabColumn> getColumnsMap() {
        return this._columns;
    }

    public Collection<SqlTabColumn> getColumns() {
        return this._columns.values();
    }

    public String getQualifiedName() {
        return this.getTable().getName() + "." + this.getName();
    }

    void add(SqlTabColumn column) {
        column.setPosition(++this.columns);
        String name = column.getName();
        if (StringUtils.isBlank((String)name)) {
            String text = "a null name column will not be added to tab " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else if (this._columns.containsKey(name)) {
            String text = "column " + name + " already added to tab " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else {
            this._columns.put(name, column);
        }
    }
}

