/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql;

import adalid.commons.util.StrUtils;
import adalid.util.sql.SqlArtifact;
import adalid.util.sql.SqlColumn;
import adalid.util.sql.SqlIndex;
import adalid.util.sql.SqlReader;
import adalid.util.sql.SqlRoutine;
import adalid.util.sql.SqlRow;
import adalid.util.sql.SqlTab;
import adalid.util.sql.SqlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SqlTable
extends SqlArtifact {
    private static final Logger logger = Logger.getLogger(SqlTable.class);
    private static final String[] no_pk_table_names = new String[]{"call_stack"};
    private final SqlReader _reader;
    private String _defaultLabel;
    private String _defaultCollectionLabel;
    private boolean _enumerable;
    private boolean _insertable;
    private boolean _updatable;
    private boolean _deletable;
    private boolean _independent;
    private boolean _loaded;
    private boolean _primaryKeyCollision;
    private boolean _businessKeyCollision;
    private boolean _versionPropertyCollision;
    private String _resourceType;
    private SqlTable _baseTable;
    private SqlColumn _primaryKey;
    private SqlColumn _businessKey;
    private Map<String, SqlColumn> _settledColumns;
    private final Map<String, SqlColumn> _columns = new LinkedHashMap<String, SqlColumn>();
    private final Map<String, SqlIndex> _indexes = new LinkedHashMap<String, SqlIndex>();
    private final Map<String, SqlTab> _tabs = new LinkedHashMap<String, SqlTab>();
    private final Map<String, SqlRow> _rows = new LinkedHashMap<String, SqlRow>();
    private final Map<String, SqlRow> _rowsByPK = new LinkedHashMap<String, SqlRow>();
    private final Map<String, SqlRoutine> _routines = new LinkedHashMap<String, SqlRoutine>();
    private final Map<SqlColumn, SqlTable> _references = new LinkedHashMap<SqlColumn, SqlTable>();
    private final Map<String, SqlTable> _extensions = new LinkedHashMap<String, SqlTable>();
    private int _discriminatorValue;
    private int indexes;
    private int rows;
    private int tabs;
    private int routines;
    private int extensions;

    public SqlTable(SqlReader reader) {
        this._reader = reader;
    }

    public SqlReader getReader() {
        return this._reader;
    }

    public String getDefaultLabel() {
        return this._defaultLabel;
    }

    void setDefaultLabel(String defaultLabel) {
        this._defaultLabel = defaultLabel;
    }

    public String getDefaultCollectionLabel() {
        return this._defaultCollectionLabel;
    }

    void setDefaultCollectionLabel(String defaultCollectionLabel) {
        this._defaultCollectionLabel = defaultCollectionLabel;
    }

    public boolean isEnumerable() {
        return this._enumerable;
    }

    void setEnumerable(boolean enumerable) {
        this._enumerable = enumerable;
    }

    public boolean isEnumeration() {
        return this._enumerable && this._businessKey != null && this._primaryKey != null && this._primaryKey.getType().equals("integer");
    }

    public boolean isUpdatableEnumeration() {
        return this.isEnumeration() && this.isUpdatable() && this.hasOrdinaryColumns();
    }

    public boolean isInsertable() {
        return this._insertable;
    }

    void setInsertable(boolean insertable) {
        this._insertable = insertable;
    }

    public boolean isUpdatable() {
        return this._updatable;
    }

    void setUpdatable(boolean updatable) {
        this._updatable = updatable;
    }

    public boolean isDeletable() {
        return this._deletable;
    }

    void setDeletable(boolean deletable) {
        this._deletable = deletable;
    }

    private boolean hasOrdinaryColumns() {
        for (SqlColumn column : this.getColumns()) {
            if (!column.isOrdinary()) continue;
            return true;
        }
        return false;
    }

    public boolean isIndependent() {
        return this._independent;
    }

    void setIndependent(boolean independent) {
        this._independent = independent;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    void setLoaded(boolean loaded) {
        this._loaded = loaded;
    }

    public String getResourceType() {
        return this._resourceType;
    }

    void setResourceType(String resourceType) {
        this._resourceType = resourceType;
    }

    public boolean isConfigurationTable() {
        return this._resourceType != null && this._resourceType.equalsIgnoreCase("configuration");
    }

    public boolean isOperationTable() {
        return this._resourceType != null && this._resourceType.equalsIgnoreCase("operation");
    }

    public boolean isCatalogTable() {
        return this._reader.getCatalogTablesMap().containsKey(this.getName());
    }

    public boolean isLoadable() {
        return this._businessKey != null && this._primaryKey != null && this._reader.getTablesLoadMap().containsKey(this.getName());
    }

    public String getFeatures() {
        ArrayList<String> features = new ArrayList<String>();
        if (this.isConfigurationTable()) {
            features.add("configuration-table");
        } else if (this.isOperationTable()) {
            features.add("operation-table");
        } else if (this._resourceType != null) {
            features.add(this._resourceType);
        } else {
            features.add("typeless");
        }
        if (this.isUpdatableEnumeration()) {
            features.add("updatable-enumeration");
        } else if (this.isEnumeration()) {
            features.add("enumeration");
        } else if (this.isEnumerable()) {
            features.add("enumerable");
        }
        if (this.isIndependent()) {
            features.add("independent");
        }
        if (this.isLoaded()) {
            features.add("loaded");
        } else if (this.isLoadable()) {
            features.add("loadable");
        }
        return "(" + StringUtils.join(features, (String)", ") + ")";
    }

    public SqlTable getBaseTable() {
        return this._baseTable;
    }

    void setBaseTable(SqlTable baseTable) {
        this._baseTable = baseTable;
    }

    public SqlColumn getPrimaryKey() {
        return this._primaryKey;
    }

    void setPrimaryKey(SqlColumn primaryKey) {
        this._primaryKey = primaryKey;
    }

    public SqlColumn getBusinessKey() {
        return this._businessKey;
    }

    void setBusinessKey(SqlColumn businessKey) {
        this._businessKey = businessKey;
    }

    public SqlColumn getVersion() {
        return this.getVersionProperty();
    }

    public SqlColumn getVersionProperty() {
        for (SqlColumn column : this._columns.values()) {
            if (!column.isVersion()) continue;
            return column;
        }
        return null;
    }

    public SqlColumn getDiscriminatorProperty() {
        for (SqlColumn column : this._columns.values()) {
            if (!column.isDiscriminator()) continue;
            return column;
        }
        return null;
    }

    public SqlColumn getNameProperty() {
        for (SqlColumn column : this._columns.values()) {
            if (!column.isName()) continue;
            return column;
        }
        return null;
    }

    public SqlColumn getDescriptionProperty() {
        for (SqlColumn column : this._columns.values()) {
            if (!column.isDescription()) continue;
            return column;
        }
        return null;
    }

    public Map<String, SqlColumn> getColumnsMap() {
        return this.getColumnsMap(true);
    }

    private Map<String, SqlColumn> getColumnsMap(boolean settled) {
        return settled ? this.getSettledColumnsMap() : this.getUnsettledColumnsMap();
    }

    public Collection<SqlColumn> getColumns() {
        return this.getColumns(true);
    }

    private Collection<SqlColumn> getColumns(boolean settled) {
        return settled ? this.getSettledColumns() : this.getUnsettledColumns();
    }

    private Map<String, SqlColumn> getSettledColumnsMap() {
        return this._settledColumns == null ? this._columns : this._settledColumns;
    }

    private Collection<SqlColumn> getSettledColumns() {
        return this._settledColumns == null ? this._columns.values() : this._settledColumns.values();
    }

    private Map<String, SqlColumn> getUnsettledColumnsMap() {
        return this._columns;
    }

    private Collection<SqlColumn> getUnsettledColumns() {
        return this._columns.values();
    }

    public Collection<SqlColumn> getOrdinaryColumns() {
        ArrayList<SqlColumn> list = new ArrayList<SqlColumn>();
        for (SqlColumn column : this.getColumns()) {
            if (!column.isOrdinary()) continue;
            list.add(column);
        }
        return list;
    }

    void settleColumns() {
        List<String> names = this.getSuperColumnsNamesList();
        if (names == null || names.isEmpty()) {
            this._settledColumns = this._columns;
        } else {
            this._settledColumns = new LinkedHashMap<String, SqlColumn>();
            for (SqlColumn column : this._columns.values()) {
                String text;
                String name = column.getName();
                if (this._settledColumns.containsKey(name)) {
                    text = "column " + name + " already settled in table " + this.getQualifiedName();
                    logger.error((Object)SqlUtil.highlight(text));
                    continue;
                }
                this._settledColumns.put(name, column);
                if (!names.contains(name) || !this.warnSameName(column)) continue;
                text = "column " + name + " is also present in a super-table of " + this.getQualifiedName();
                logger.warn((Object)SqlUtil.highlight(text));
            }
        }
        this.checkColumnNameCollisions();
    }

    private void checkColumnNameCollisions() {
        SqlColumn versionProperty;
        String colname;
        Object text;
        String pattern = "column {0}.{1} has the same name as the default {2} of entity {3}";
        String tabname = this.getQualifiedName();
        String nttname = this.getCapitalizedJavaName();
        if (this._primaryKey == null) {
            if (ArrayUtils.contains((Object[])no_pk_table_names, (Object)tabname)) {
                text = "table " + this.getQualifiedName() + " does not have a proper primary key";
                logger.info(text);
            } else {
                text = "table " + this.getQualifiedName() + " does not have a primary key";
                logger.warn((Object)SqlUtil.highlight((String)text));
            }
            colname = this.isEnumeration() ? "numero" : "id";
            text = StrUtils.getStringParametrizado("column {0}.{1} has the same name as the default {2} of entity {3}", tabname, colname, "primary key", nttname);
            this._primaryKeyCollision = this.columnNameCollision(colname, (String)text);
        }
        if (this._businessKey == null && this.isEnumeration()) {
            colname = "codigo";
            text = StrUtils.getStringParametrizado("column {0}.{1} has the same name as the default {2} of entity {3}", tabname, colname, "business key", nttname);
            this._businessKeyCollision = this.columnNameCollision(colname, (String)text);
        }
        if ((versionProperty = this.getVersionProperty()) == null && (this.isUpdatableEnumeration() || !this.isEnumeration())) {
            colname = "version";
            text = StrUtils.getStringParametrizado("column {0}.{1} has the same name as the default {2} of entity {3}", tabname, colname, "version property", nttname);
            this._versionPropertyCollision = this.columnNameCollision(colname, (String)text);
        }
    }

    private boolean columnNameCollision(String name, String text) {
        SqlColumn column = this._columns.get(name);
        if (column != null) {
            column.setCollision(true);
            logger.error((Object)SqlUtil.highlight(text));
            return true;
        }
        return false;
    }

    public boolean isPrimaryKeyCollision() {
        return this._primaryKeyCollision;
    }

    public boolean isBusinessKeyCollision() {
        return this._businessKeyCollision;
    }

    public boolean isVersionPropertyCollision() {
        return this._versionPropertyCollision;
    }

    private boolean warnSameName(SqlColumn column) {
        return !column.isPrimary();
    }

    private List<String> getSuperColumnsNamesList() {
        ArrayList<String> list = new ArrayList<String>();
        SqlTable superTable = this.getSuperTable();
        if (superTable != null) {
            list.addAll(superTable.getSuperColumnsNamesList());
            Collection<SqlColumn> columns = superTable.getColumns();
            for (SqlColumn col : columns) {
                list.add(col.getName());
            }
        }
        return list;
    }

    public SqlColumn getSqlColumn(String name) {
        for (SqlColumn sqlColumn : this.getColumns()) {
            if (!sqlColumn.getName().equals(name)) continue;
            return sqlColumn;
        }
        return null;
    }

    public Map<String, SqlIndex> getIndexesMap() {
        return this._indexes;
    }

    public Collection<SqlIndex> getIndexes() {
        return this._indexes.values();
    }

    public Map<String, SqlRow> getRowsMap() {
        return this._rows;
    }

    public Collection<SqlRow> getRows() {
        return this._rows.values();
    }

    public Map<String, SqlRow> getRowsByPrimaryKeyMap() {
        return this._rowsByPK;
    }

    public Set<String> getPrimaryKeys() {
        return this._rowsByPK.keySet();
    }

    public Map<String, SqlTab> getTabsMap() {
        return this._tabs;
    }

    public Collection<SqlTab> getTabs() {
        return this._tabs.values();
    }

    public Map<String, SqlRoutine> getRoutinesMap() {
        return this._routines;
    }

    public Collection<SqlRoutine> getRoutines() {
        return this._routines.values();
    }

    public Map<SqlColumn, SqlTable> getReferences() {
        return this._references;
    }

    public Map<String, SqlTable> getExtensions() {
        return this._extensions;
    }

    public boolean isRoot() {
        return !this._extensions.isEmpty();
    }

    public int getDiscriminatorValue() {
        return this._discriminatorValue;
    }

    private void setDiscriminatorValue(int discriminatorValue) {
        this._discriminatorValue = discriminatorValue;
    }

    public SqlTable getRootTable() {
        SqlTable rootTable = this.rootTable();
        return rootTable.equals(this) ? null : rootTable;
    }

    private SqlTable rootTable() {
        SqlTable superTable = this.getSuperTable();
        return superTable == null ? this : superTable.rootTable();
    }

    public SqlTable getSuperTable() {
        SqlTable superTable = this._primaryKey == null ? null : this._primaryKey.getForeignTable();
        return superTable == this ? null : superTable;
    }

    public String getQualifiedName() {
        return this.getName();
    }

    void add(SqlColumn column) {
        String name = column.getName();
        if (StringUtils.isBlank((String)name)) {
            String text = "a null name column will not be added to table " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else if (this._columns.containsKey(name)) {
            String text = "column " + name + " already added to table " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else {
            this._columns.put(name, column);
        }
    }

    void add(SqlIndex index) {
        index.setPosition(++this.indexes);
        String name = index.getName();
        if (StringUtils.isBlank((String)name)) {
            String text = "a null name index will not be added to table " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else if (this._indexes.containsKey(name)) {
            String text = "index " + name + " already added to table " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else {
            this._indexes.put(name, index);
        }
    }

    void add(SqlRow row) {
        String text;
        row.setPosition(++this.rows);
        String name = row.getName();
        if (StringUtils.isBlank((String)name)) {
            text = "a null name row will not be added to table " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else if (this._rows.containsKey(name)) {
            text = "row " + name + " already added to table " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else {
            this._rows.put(name, row);
        }
        String pkey = StringUtils.leftPad((String)row.getPrimaryKey().getValue(), (int)19, (char)'0');
        if (pkey == null) {
            text = "a null primary-key row will not be added to table " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else if (this._rowsByPK.containsKey(pkey)) {
            text = "row " + pkey + " already added to table " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else {
            this._rowsByPK.put(pkey, row);
        }
    }

    void add(SqlTab tab) {
        tab.setPosition(++this.tabs);
        String name = tab.getName();
        if (StringUtils.isBlank((String)name)) {
            String text = "a null name tab will not be added to table " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else if (this._tabs.containsKey(name)) {
            String text = "tab " + name + " already added to table " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else {
            this._tabs.put(name, tab);
        }
    }

    void add(SqlRoutine routine) {
        routine.setPosition(++this.routines);
        String name = routine.getName();
        if (StringUtils.isBlank((String)name)) {
            String text = "a null name routine will not be added to table " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else if (this._routines.containsKey(name)) {
            String text = "routine " + name + " already added to table " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else {
            this._routines.put(name, routine);
        }
    }

    void add(SqlTable extension) {
        int discriminatorValue = ++this.extensions;
        extension.setDiscriminatorValue(discriminatorValue);
        String name = extension.getName();
        if (StringUtils.isBlank((String)name)) {
            String text = "a null name table extension will not be added to table " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else if (this._extensions.containsKey(name)) {
            String text = "table extension " + name + " already added to table " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else {
            this._extensions.put(name, extension);
        }
    }
}

