/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql;

import adalid.commons.TLB;
import adalid.commons.interfaces.Programmer;
import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.FilUtils;
import adalid.util.Utility;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import javax.swing.JOptionPane;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SqlUtil {
    private static final Logger logger = Logger.getLogger(SqlUtil.class);
    private static final ExtendedProperties bootstrapping = PropertiesHandler.getBootstrapping();
    protected String _dbms;
    protected String _host;
    protected String _port;
    protected String _user;
    protected String _password;
    protected String _database;
    protected String _schema;
    protected String _urlPattern;
    protected String _driver;
    protected String _programmer;
    protected String _url;
    protected Connection _connection;
    protected boolean _initialised;
    protected int _argIndex;
    protected String[] _args;
    private boolean _argx;

    static String highlight(String text) {
        return "WATCH OUT! " + text;
    }

    public SqlUtil() {
        this.args();
    }

    public SqlUtil(String[] args) {
        if (args == null || args.length == 0) {
            this.args();
        } else {
            this._args = args;
            this._argx = true;
            this._initialised = true;
            this._initialised = this._initialised && this.dbms(this._argIndex++, args);
            this.init();
        }
    }

    private void args() {
        if (this.dbms()) {
            String name = this.getClass().getName() + "." + this._dbms;
            this._args = Utility.getArguments(name);
            this._initialised = this._args != null && this._args.length > 0;
            this.init();
        }
    }

    private void init() {
        this._initialised = this._initialised && this.host(this._argIndex++, this._args);
        this._initialised = this._initialised && this.port(this._argIndex++, this._args);
        this._initialised = this._initialised && this.user(this._argIndex++, this._args);
        this._initialised = this._initialised && this.password(this._argIndex++, this._args);
        this._initialised = this._initialised && this.database(this._argIndex++, this._args);
        this._initialised = this._initialised && this.schema(this._argIndex++, this._args);
    }

    private boolean dbms() {
        String message = "DBMS";
        String title = "Choose";
        int type = 3;
        Object[] values = new Object[]{"postgresql", "oracle"};
        Object initialValue = values[0];
        logger.info((Object)("Choose " + message + " " + Arrays.toString(values)));
        Object value = JOptionPane.showInputDialog(null, message, "Choose", 3, null, values, initialValue);
        this._dbms = value == null ? null : value.toString();
        return this.dbms(false);
    }

    private boolean dbms(int i, String[] args) {
        this._dbms = this.arg(i, args).toLowerCase();
        return this.dbms(true);
    }

    private boolean dbms(boolean logSyntaxError) {
        if (StringUtils.isNotBlank((String)this._dbms)) {
            Object object;
            this._urlPattern = bootstrapping.getString(this._dbms + ".string");
            this._driver = bootstrapping.getString(this._dbms + ".driver");
            this._programmer = bootstrapping.getString(this._dbms + ".programmer");
            if (StringUtils.isNotBlank((String)this._urlPattern) && StringUtils.isNotBlank((String)this._driver) && StringUtils.isNotBlank((String)this._programmer) && (object = this.getNewInstanceForName(this._programmer)) instanceof Programmer) {
                TLB.setProgrammer(this._dbms, (Programmer)object);
                this.logValidArgument("dbms", this._dbms);
                return true;
            }
        }
        this.logInvalidArgument("dbms", this._dbms);
        if (logSyntaxError) {
            this.logSyntaxError();
        }
        return false;
    }

    private boolean host(int i, String[] args) {
        this._host = this.arg(i, args);
        if (StringUtils.isNotBlank((String)this._host)) {
            this.logValidArgument("host", this._host);
            return true;
        }
        this.logInvalidArgument("host", this._host);
        this.logSyntaxError();
        return false;
    }

    private boolean port(int i, String[] args) {
        this._port = this.arg(i, args);
        if (StringUtils.isNotBlank((String)this._port)) {
            this.logValidArgument("port", this._port);
            return true;
        }
        this.logInvalidArgument("port", this._port);
        this.logSyntaxError();
        return false;
    }

    private boolean user(int i, String[] args) {
        this._user = this.arg(i, args);
        if (StringUtils.isNotBlank((String)this._user)) {
            this.logValidArgument("user", this._user);
            return true;
        }
        this.logInvalidArgument("user", this._user);
        this.logSyntaxError();
        return false;
    }

    private boolean password(int i, String[] args) {
        this._password = this.arg(i, args);
        if (StringUtils.isNotBlank((String)this._password)) {
            return true;
        }
        this.logInvalidArgument("password", this._password);
        this.logSyntaxError();
        return false;
    }

    private boolean database(int i, String[] args) {
        this._database = this.arg(i, args);
        if (StringUtils.isNotBlank((String)this._database)) {
            this.logValidArgument("database", this._database);
            return true;
        }
        this.logInvalidArgument("database", this._database);
        this.logSyntaxError();
        return false;
    }

    private boolean schema(int i, String[] args) {
        this._schema = this.arg(i, args);
        if (StringUtils.isNotBlank((String)this._schema)) {
            this.logValidArgument("schema", this._schema);
            return true;
        }
        this.logInvalidArgument("schema", this._schema);
        this.logSyntaxError();
        return false;
    }

    protected String arg(int i, String[] args) {
        return args != null && args.length > i && args[i] != null ? args[i].trim() : "";
    }

    protected void logValidArgument(String param, String arg) {
        logger.info((Object)(param + " = \"" + arg + "\" "));
    }

    protected void logInvalidArgument(String param, String arg) {
        if (arg == null) {
            logger.error((Object)(param + " is null"));
        } else {
            logger.error((Object)(param + " \"" + arg + "\" is invalid"));
        }
    }

    protected void logSyntaxError() {
        logger.error((Object)this.getSyntax());
    }

    protected String getSyntax() {
        return this.getSqlUtilSyntax();
    }

    protected final String getSqlUtilSyntax() {
        String dbms = this._argx ? " dbms," : "";
        return "Syntax: " + this.getClass().getSimpleName() + dbms + " host, port, user, password, database, schema";
    }

    protected Object getNewInstanceForName(String className) {
        Class<?> clazz = this.getClassForName(className);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Class<?> getClassForName(String className) {
        if (StringUtils.isBlank((String)className)) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected boolean connect() {
        logger.info((Object)"connect");
        if (this._connection == null) {
            boolean oracle = StringUtils.equalsIgnoreCase((String)this._dbms, (String)"oracle");
            String user = oracle ? this._user.toUpperCase() : this._user;
            this._url = this._urlPattern;
            this._url = this._url.replace("%dbhost%", this._host);
            this._url = this._url.replace("%dbport%", this._port);
            this._url = this._url.replace("%dbuser%", user);
            this._url = this._url.replace("%dbpass%", this._password);
            this._url = this._url.replace("%dbname%", this._database);
            try {
                Class.forName(this._driver);
                this._connection = DriverManager.getConnection(this._url, user, this._password);
                logger.info((Object)(this._url + " connection opened"));
            }
            catch (ClassNotFoundException | SQLException ex) {
                this._connection = null;
                logger.fatal((Object)this._url, (Throwable)ex);
            }
        }
        return this._connection != null;
    }

    protected boolean close() {
        logger.info((Object)"close");
        if (this._connection != null) {
            try {
                if (!this._connection.isClosed()) {
                    this._connection.close();
                }
                logger.info((Object)(this._url + " connection closed "));
                this._connection = null;
                this._url = null;
            }
            catch (SQLException ex) {
                logger.fatal((Object)this._url, (Throwable)ex);
            }
        }
        return this._connection == null;
    }

    protected boolean isRemoteConnection() {
        return this._host != null && !this._host.equals("127.0.0.1") && !this._host.equalsIgnoreCase("localhost");
    }

    protected boolean executeStatement(String statement) throws SQLException {
        try {
            logger.debug((Object)(this._url + " " + statement));
            PreparedStatement prepareStatement = this._connection.prepareStatement(statement);
            return prepareStatement.execute();
        }
        catch (SQLException ex) {
            logger.fatal((Object)statement, (Throwable)ex);
            throw ex;
        }
    }

    protected PreparedStatement prepareStatement(String statement) {
        try {
            logger.debug((Object)(this._url + " " + statement));
            return this._connection.prepareStatement(statement);
        }
        catch (SQLException ex) {
            logger.fatal((Object)statement, (Throwable)ex);
            return null;
        }
    }

    protected void close(PreparedStatementWrapper wrapper) {
        if (wrapper != null) {
            this.close(wrapper.getPreparedStatement());
        }
    }

    protected void close(PreparedStatement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                logger.fatal((Object)statement, (Throwable)ex);
            }
        }
    }

    public String getDbms() {
        return this._dbms;
    }

    public String getHost() {
        return this._host;
    }

    public String getPort() {
        return this._port;
    }

    public String getUser() {
        return this._user;
    }

    public String getPassword() {
        return this._password;
    }

    public String getDatabase() {
        return this._database;
    }

    public String getSchema() {
        return this._schema;
    }

    public String getDriver() {
        return this._driver;
    }

    public String getUrl() {
        return this._url;
    }

    public boolean isInitialised() {
        return this._initialised;
    }

    public String getMetajavaPath() {
        String path1 = bootstrapping.getString("metajava.path");
        String path2 = FilUtils.fixPath(path1);
        String path3 = FilUtils.slashedPath(path2);
        return path3;
    }

    public String getCommonsPackage() {
        return bootstrapping.getString("commons.package.name");
    }

    public String getDefaultPackage() {
        return bootstrapping.getString("default.package.name");
    }

    public String getSourceMetajavaPackage() {
        return this.getCommonsPackage();
    }

    public String getTargetMetajavaPackage() {
        return this.getDefaultPackage() + "." + this._database.toLowerCase();
    }

    protected class PreparedStatementWrapper {
        String _statement;
        PreparedStatement _preparedStatement;

        public PreparedStatementWrapper(String statement) {
            this._statement = statement;
            this._preparedStatement = SqlUtil.this.prepareStatement(statement);
        }

        public String getStatement() {
            return this._statement;
        }

        public PreparedStatement getPreparedStatement() {
            return this._preparedStatement;
        }

        public ResultSet executeQuery() throws SQLException {
            return this.executeQuery(null);
        }

        public ResultSet executeQuery(Object[] args) throws SQLException {
            int n;
            int n2 = n = args == null ? 0 : args.length;
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    if (args[i] == null) {
                        this._preparedStatement.setNull(i + 1, 0);
                        continue;
                    }
                    this._preparedStatement.setObject(i + 1, args[i]);
                }
            }
            return this._preparedStatement.executeQuery();
        }

        public String toString() {
            return this._statement;
        }
    }
}

