/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql;

import adalid.commons.util.JavaUtils;
import adalid.commons.velocity.Writer;
import adalid.util.sql.SqlReader;
import adalid.util.sql.SqlTable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SqlWriter
extends SqlReader {
    private static final Logger logger = Logger.getLogger(SqlWriter.class);
    private String _projectAlias;
    private static final String PROJECT_ALIAS_PATTERN = "^[a-z][a-z0-9]*$";
    private String _projectPlatform;
    private boolean _createAndDropDefaults;
    private String _targetMetaProjectsPackage;
    private String _targetMetaEntitiesPackage;
    private static final String COLLISION_SUFFIX = "1d3c5";
    private int _maxTablePrefixLength;
    private final Map<String, Set<SqlTable>> _modules = new TreeMap<String, Set<SqlTable>>();
    private static final String PREFIJO_MODULO = "Modulo";
    private static final String MODULO_UNO = "Modulo1";

    public SqlWriter() {
        this.init();
    }

    public SqlWriter(String[] args) {
        super(args);
        this.init();
    }

    private void init() {
        this.setSelectTemplatesPath("templates/meta/java/sql/select/010");
    }

    public String getProjectAlias() {
        return this._projectAlias == null ? this.defaultProjectAlias() : this._projectAlias;
    }

    public String getProjectShortAlias() {
        return this._projectAlias == null ? this.defaultProjectShortAlias() : this._projectAlias;
    }

    public void setProjectAlias(String alias) {
        if (StringUtils.isBlank((String)alias)) {
            logger.warn((Object)("null value for alias parameter; project alias remains " + this.getProjectAlias()));
        } else if (!alias.matches(PROJECT_ALIAS_PATTERN)) {
            logger.warn((Object)(alias + " is an invalid project alias; project alias remains " + this.getProjectAlias()));
        } else if (alias.equalsIgnoreCase("meta") || alias.equalsIgnoreCase("workspace")) {
            logger.warn((Object)(alias + " is a restricted project alias; project alias remains " + this.getProjectAlias()));
        } else {
            this._projectAlias = alias;
        }
    }

    private String defaultProjectShortAlias() {
        boolean oracle = StringUtils.equalsIgnoreCase((String)this._dbms, (String)"oracle");
        return (oracle ? this._schema : this._database).toLowerCase();
    }

    private String defaultProjectAlias() {
        String MAVEN = "1";
        String POSTGRESQL = "0";
        String ORACLE = "1";
        String GLASSFISH = "1";
        String WILDFLY = "2";
        boolean oracle = StringUtils.equalsIgnoreCase((String)this._dbms, (String)"oracle");
        return this.defaultProjectShortAlias() + "1" + (oracle ? "1" : "0") + (StringUtils.containsIgnoreCase((String)this.getProjectPlatform(), (String)"glassfish") ? "1" : "2");
    }

    private boolean checkProjectAlias() {
        String alias = this.getProjectAlias();
        if (StringUtils.isBlank((String)alias)) {
            logger.error((Object)"invalid project alias; generation aborted");
            return false;
        }
        if (!alias.matches(PROJECT_ALIAS_PATTERN)) {
            logger.error((Object)(alias + " is an invalid project alias; generation aborted"));
            return false;
        }
        if (alias.equalsIgnoreCase("meta") || alias.equalsIgnoreCase("workspace")) {
            logger.error((Object)(alias + " is a restricted project alias; generation aborted"));
            return false;
        }
        return true;
    }

    public String getProjectPlatform() {
        return this._projectPlatform == null ? this.defaultProjectPlatform() : this._projectPlatform;
    }

    private String defaultProjectPlatform() {
        Object[] array = new String[]{"PLATAFORMA", "MAVEN", this._dbms.toUpperCase(), "WILDFLY"};
        return StringUtils.join((Object[])array, (char)'_');
    }

    public boolean isCreateAndDropDefaults() {
        return this._createAndDropDefaults;
    }

    public void setCreateAndDropDefaults(boolean b) {
        this._createAndDropDefaults = b;
    }

    @Override
    public String getTargetMetajavaPackage() {
        return this.getDefaultPackage() + "." + this.getProjectShortAlias();
    }

    public String getTargetMetaProjectsPackage() {
        return StringUtils.isNotBlank((String)this._targetMetaProjectsPackage) ? this._targetMetaProjectsPackage : this.getTargetMetajavaPackage();
    }

    public void setTargetMetaProjectsPackage(String packageName) {
        this._targetMetaProjectsPackage = packageName;
    }

    public String getTargetMetaEntitiesPackage() {
        return StringUtils.isNotBlank((String)this._targetMetaEntitiesPackage) ? this._targetMetaEntitiesPackage : this.getTargetMetajavaPackage() + ".entities";
    }

    public void setTargetMetaEntitiesPackage(String packageName) {
        this._targetMetaEntitiesPackage = packageName;
    }

    public String getCollisionSuffix() {
        return COLLISION_SUFFIX;
    }

    public Set<String> getJavaKeywords() {
        return JavaUtils.getJavaKeywordSet();
    }

    public int getTableNameError(String tabname) {
        if (StringUtils.isBlank((String)tabname)) {
            logger.error((Object)"missing table name");
            return -1;
        }
        if (tabname.length() < 2) {
            logger.error((Object)(tabname + " must be renamed; " + tabname + " is too short an artifact name"));
            return 1;
        }
        if (!tabname.matches("^[A-Z][a-z]\\w*$")) {
            logger.error((Object)(tabname + " must be renamed; " + tabname + " is an invalid artifact name (it does not begin with [A-Z][a-z])"));
            return 2;
        }
        return 0;
    }

    public int getColumnNameError(String tabname, String colname) {
        if (StringUtils.isBlank((String)tabname)) {
            logger.error((Object)"missing table name");
            return -1;
        }
        if (StringUtils.isBlank((String)colname)) {
            logger.error((Object)"missing column name");
            return -1;
        }
        if (colname.length() < 2) {
            logger.error((Object)(tabname + "." + colname + " must be renamed; " + colname + " is too short an artifact name"));
            return 1;
        }
        if (!colname.matches("^[a-zA-Z]\\w*$")) {
            logger.error((Object)(tabname + "." + colname + " must be renamed; " + colname + " is an invalid artifact name (it does not begin with [a-zA-Z])"));
            return 2;
        }
        if (colname.matches("^[a-z][A-Z].*$")) {
            logger.error((Object)(tabname + "." + colname + " must be renamed; " + colname + " is an invalid artifact name (it begins with [a-z][A-Z])"));
            return 3;
        }
        if (colname.matches("^[A-Z][A-Z]+[a-z].*$")) {
            logger.error((Object)(tabname + "." + colname + " must be renamed; " + colname + " is an invalid artifact name (it begins with [A-Z][A-Z]+[a-z])"));
            return 4;
        }
        return 0;
    }

    public int isMaxTablePrefixLength() {
        return this._maxTablePrefixLength;
    }

    public void setMaxTablePrefixLength(int prefixLength) {
        this._maxTablePrefixLength = prefixLength;
    }

    public Set<String> getModules() {
        if (this._modules.isEmpty()) {
            this.fillModules();
        }
        return this._modules.keySet();
    }

    private void fillModules() {
        Object module = MODULO_UNO;
        Map<String, SqlTable> tables = this.getTablesMap();
        Set<String> tableNames = tables.keySet();
        for (String name : tableNames) {
            Set<Object> set;
            if (this._maxTablePrefixLength > 0) {
                String prefix = StringUtils.substringBefore((String)name, (String)"_").toUpperCase();
                Object object = module = prefix.length() > this._maxTablePrefixLength ? MODULO_UNO : PREFIJO_MODULO + prefix;
            }
            if (this._modules.containsKey(module)) {
                set = this._modules.get(module);
            } else {
                set = new LinkedHashSet();
                this._modules.put((String)module, set);
            }
            SqlTable table = tables.get(name);
            set.add(table);
        }
    }

    public Collection<SqlTable> getTables(String module) {
        return this._modules.get(module);
    }

    public String getModuleID(String module) {
        return StringUtils.substringAfter((String)module, (String)PREFIJO_MODULO);
    }

    public boolean write() {
        logger.info((Object)"write");
        boolean ok = this.checkProjectAlias();
        if (ok && this.read(true)) {
            Writer writer = new Writer(this, "reader");
            writer.write("meta-java-sql");
            return true;
        }
        return false;
    }

    @Override
    protected boolean beforeReadBuild() {
        if (this._createAndDropDefaults) {
            try {
                this.getSqlAid().createDefaults();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    protected boolean beforeReadClose() {
        if (this._createAndDropDefaults) {
            try {
                this.getSqlAid().dropDefaults();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return true;
    }
}

