/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql.jee2;

import adalid.util.Utility;
import adalid.util.sql.SqlWriter;
import meta.proyecto.comun.EntidadesComunes;
import org.apache.log4j.Logger;

public class SQLWriter
extends Utility {
    private static final Logger logger = Logger.getLogger(SqlWriter.class);
    private static final String[] TABLAS_EXCLUIDAS = new String[]{"dual", "recurso", "zyx"};

    public static void write(String[] args) {
        SQLWriter.write(args, 0);
    }

    public static void write(String[] args, int maxPrefijo) {
        SQLWriter.write(args, maxPrefijo, TABLAS_EXCLUIDAS);
    }

    public static void write(String[] args, String[] tablasExcluidas) {
        SQLWriter.write(args, 0, tablasExcluidas);
    }

    public static void write(String[] args, int maxPrefijo, String[] tablasExcluidas) {
        SqlWriter writer = new SqlWriter(args);
        if (writer.isInitialised()) {
            logger.info((Object)("projectAlias=" + writer.getProjectAlias()));
            EntidadesComunes entidadesComunes = new EntidadesComunes();
            if (entidadesComunes.build()) {
                writer.setMaxTablePrefixLength(maxPrefijo);
                writer.setTablesExcludeSet(tablasExcluidas);
                writer.setTablesInheritMap(entidadesComunes.getTablesMap());
                writer.setLoadConfigurationTables(false);
                writer.write();
            }
            SQLWriter.updateProjectBuilderDictionary(SQLWriter.class);
        }
    }
}

