/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.auditoria;

import adalid.core.AbstractPersistentEntity;
import adalid.core.ExportOperation;
import adalid.core.ReportOperation;
import adalid.core.View;
import adalid.core.ViewField;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityReportOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityTriggers;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ExportOperationClass;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.ReportOperationClass;
import adalid.core.annotations.StringField;
import adalid.core.annotations.UniformResourceLocator;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SortOption;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.enums.StandardRelationalOp;
import adalid.core.enums.UrlDisplayType;
import adalid.core.enums.UrlType;
import adalid.core.expressions.BooleanComparisonX;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.Segment;
import adalid.core.page.format.DefaultPageFormat;
import adalid.core.parameters.BooleanParameter;
import adalid.core.parameters.StringParameter;
import adalid.core.parameters.TimestampParameter;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.auditoria.RastroFuncion;
import meta.entidad.comun.configuracion.basica.Funcion;
import meta.entidad.comun.configuracion.basica.Parametro;
import meta.entidad.comun.control.acceso.Usuario;

@EntityClass(independent=Kleenean.FALSE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.MASCULINE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE, access=OperationAccess.RESTRICTED)
@EntityInsertOperation(enabled=Kleenean.FALSE)
@EntityUpdateOperation(enabled=Kleenean.FALSE)
@EntityDeleteOperation(enabled=Kleenean.FALSE)
@EntityReportOperation(enabled=Kleenean.FALSE)
@EntityTableView(enabled=Kleenean.FALSE)
@EntityDetailView(enabled=Kleenean.FALSE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.TRUE)
@EntityTriggers(afterValue=Kleenean.TRUE)
public class RastroFuncionPar
extends AbstractPersistentEntity {
    private static final String CONVERTIDOR_VALOR = "convertidorValorRastroFuncionPar";
    @PrimaryKey
    public LongProperty id;
    @ForeignKey(onDelete=OnDeleteAction.CASCADE, onUpdate=OnUpdateAction.CASCADE)
    @ManyToOne(navigability=Navigability.BIDIRECTIONAL, view=MasterDetailView.TABLE_AND_DETAIL)
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE)
    public RastroFuncion rastroFuncion;
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE)
    public Parametro parametro;
    @StringField(maxLength=200)
    public StringProperty codigoParametro;
    @StringField(maxLength=200)
    public StringProperty nombreParametro;
    @PropertyField(sequence=110, table=Kleenean.FALSE, report=Kleenean.FALSE, export=Kleenean.FALSE)
    @StringField(converter="convertidorValorRastroFuncionPar", maxLength=0)
    public StringProperty valorParametro;
    @PropertyField(sequence=120, table=Kleenean.FALSE, report=Kleenean.FALSE, export=Kleenean.FALSE)
    public StringProperty codigoRecursoParametro;
    @PropertyField(sequence=130, table=Kleenean.FALSE, report=Kleenean.FALSE, export=Kleenean.FALSE)
    public StringProperty nombreRecursoParametro;
    @PropertyField(sequence=100, table=Kleenean.TRUE, report=Kleenean.FALSE, export=Kleenean.FALSE)
    @StringField(converter="convertidorValorRastroFuncionPar", maxLength=0)
    public StringProperty valorAparenteParametro;
    @PropertyField(sequence=110, table=Kleenean.FALSE, report=Kleenean.FALSE, export=Kleenean.FALSE)
    @StringField(converter="convertidorValorRastroFuncionPar", maxLength=0)
    public StringProperty valorAnterior;
    @PropertyField(sequence=120, table=Kleenean.FALSE, report=Kleenean.FALSE, export=Kleenean.FALSE)
    public StringProperty codigoRecursoAnterior;
    @PropertyField(sequence=130, table=Kleenean.FALSE, report=Kleenean.FALSE, export=Kleenean.FALSE)
    public StringProperty nombreRecursoAnterior;
    @PropertyField(sequence=100, table=Kleenean.TRUE, report=Kleenean.FALSE, export=Kleenean.FALSE)
    @StringField(converter="convertidorValorRastroFuncionPar", maxLength=0)
    public StringProperty valorAparenteAnterior;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(sequence=200, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public BooleanProperty diferenteValor;
    @PropertyField(sequence=800, hidden=Kleenean.TRUE)
    public LongProperty idClaseRecursoValor;
    @UniformResourceLocator(urlType=UrlType.INTERNAL, urlDisplayType=UrlDisplayType.BUTTON)
    @PropertyField(sequence=800, hidden=Kleenean.TRUE)
    public StringProperty paginaRecurso;
    protected Segment dml;
    protected Segment biz;
    protected View rastrosConParametros;
    protected ExportarArchivoRastrosConParametros archivoRastrosConParametros;
    protected EmitirInformeRastrosConParametros informeRastrosConParametros;

    public RastroFuncionPar(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings("rastroFuncion.usuario", "rastroFuncion.funcion", "rastroFuncion.tipoFuncion", "rastroFuncion.recursoValor", "rastroFuncion.condicionEjeFun");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "function parameter audit trail");
        this.setLocalizedLabel(SPANISH, "rastro de auditor\u00eda de par\u00e1metro de funci\u00f3n");
        this.setLocalizedShortLabel(ENGLISH, "parameter trail");
        this.setLocalizedShortLabel(SPANISH, "rastro de par\u00e1metro");
        this.setLocalizedCollectionLabel(ENGLISH, "Function Parameter Audit Trails");
        this.setLocalizedCollectionLabel(SPANISH, "Rastros de Auditor\u00eda de Par\u00e1metros");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Parameter Trails");
        this.setLocalizedCollectionShortLabel(SPANISH, "Rastros de Par\u00e1metros");
        this.setLocalizedDescription(ENGLISH, "Each instance of " + this.b("Function Parameter Audit Trails") + " represents an audit trail of the parameters of the execution of CRUD operations and business processes.");
        this.setLocalizedDescription(SPANISH, "Cada instancia de " + this.b("Rastros de Auditor\u00eda de Par\u00e1metros") + " representa un rastro de auditor\u00eda de los par\u00e1metros de la ejecuci\u00f3n de operaciones de registro y procesos de negocio.");
        this.setLocalizedShortDescription(ENGLISH, "audit trail of the parameters of the execution of CRUD operations and business processes");
        this.setLocalizedShortDescription(SPANISH, "rastro de auditor\u00eda de los par\u00e1metros de la ejecuci\u00f3n de operaciones de registro y procesos de negocio");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.diferenteValor.setInitialValue(false);
        this.diferenteValor.setDefaultValue(false);
        String suffix = "; only applies to update operations";
        String sufijo = "; solo aplica a operaciones de actualizaci\u00f3n";
        this.rastroFuncion.setLocalizedLabel(ENGLISH, "function trail");
        this.rastroFuncion.setLocalizedLabel(SPANISH, "rastro de funci\u00f3n");
        this.rastroFuncion.setLocalizedShortLabel(ENGLISH, "trail");
        this.rastroFuncion.setLocalizedShortLabel(SPANISH, "rastro");
        this.parametro.setLocalizedDescription(ENGLISH, "parameter");
        this.parametro.setLocalizedDescription(SPANISH, "par\u00e1metro");
        this.parametro.setLocalizedLabel(ENGLISH, "parameter");
        this.parametro.setLocalizedLabel(SPANISH, "par\u00e1metro");
        this.codigoParametro.setLocalizedDescription(ENGLISH, "parameter code");
        this.codigoParametro.setLocalizedDescription(SPANISH, "c\u00f3digo del par\u00e1metro");
        this.codigoParametro.setLocalizedLabel(ENGLISH, "parameter code");
        this.codigoParametro.setLocalizedLabel(SPANISH, "c\u00f3digo del par\u00e1metro");
        this.nombreParametro.setLocalizedDescription(ENGLISH, "parameter name");
        this.nombreParametro.setLocalizedDescription(SPANISH, "nombre del par\u00e1metro");
        this.nombreParametro.setLocalizedLabel(ENGLISH, "parameter name");
        this.nombreParametro.setLocalizedLabel(SPANISH, "nombre del par\u00e1metro");
        this.valorParametro.setLocalizedDescription(ENGLISH, "unformatted text representing the parameter value");
        this.valorParametro.setLocalizedDescription(SPANISH, "texto sin formato que representa el valor del par\u00e1metro");
        this.valorParametro.setLocalizedLabel(ENGLISH, "unformatted value");
        this.valorParametro.setLocalizedLabel(SPANISH, "valor sin formato");
        this.codigoRecursoParametro.setLocalizedDescription(ENGLISH, "code corresponding to the parameter value");
        this.codigoRecursoParametro.setLocalizedDescription(SPANISH, "c\u00f3digo correspondiente al valor del par\u00e1metro");
        this.codigoRecursoParametro.setLocalizedLabel(ENGLISH, "value code");
        this.codigoRecursoParametro.setLocalizedLabel(SPANISH, "c\u00f3digo del valor");
        this.nombreRecursoParametro.setLocalizedDescription(ENGLISH, "name corresponding to the parameter value");
        this.nombreRecursoParametro.setLocalizedDescription(SPANISH, "nombre correspondiente al valor del par\u00e1metro");
        this.nombreRecursoParametro.setLocalizedLabel(ENGLISH, "value name");
        this.nombreRecursoParametro.setLocalizedLabel(SPANISH, "nombre del valor");
        this.valorAparenteParametro.setLocalizedDescription(ENGLISH, "formatted text representing the parameter value");
        this.valorAparenteParametro.setLocalizedDescription(SPANISH, "texto con formato que representa el valor del par\u00e1metro");
        this.valorAparenteParametro.setLocalizedLabel(ENGLISH, "value");
        this.valorAparenteParametro.setLocalizedLabel(SPANISH, "valor");
        this.valorAnterior.setLocalizedDescription(ENGLISH, "unformatted text representing the previous parameter value; only applies to update operations");
        this.valorAnterior.setLocalizedDescription(SPANISH, "texto sin formato que representa el valor anterior del par\u00e1metro; solo aplica a operaciones de actualizaci\u00f3n");
        this.valorAnterior.setLocalizedLabel(ENGLISH, "unformatted previous value");
        this.valorAnterior.setLocalizedLabel(SPANISH, "valor anterior sin formato");
        this.codigoRecursoAnterior.setLocalizedDescription(ENGLISH, "code corresponding to the previous parameter value; only applies to update operations");
        this.codigoRecursoAnterior.setLocalizedDescription(SPANISH, "c\u00f3digo correspondiente al valor anterior del par\u00e1metro; solo aplica a operaciones de actualizaci\u00f3n");
        this.codigoRecursoAnterior.setLocalizedLabel(ENGLISH, "previous value code");
        this.codigoRecursoAnterior.setLocalizedLabel(SPANISH, "c\u00f3digo del valor anterior");
        this.nombreRecursoAnterior.setLocalizedDescription(ENGLISH, "name corresponding to the previous parameter value; only applies to update operations");
        this.nombreRecursoAnterior.setLocalizedDescription(SPANISH, "nombre correspondiente al valor anterior del par\u00e1metro; solo aplica a operaciones de actualizaci\u00f3n");
        this.nombreRecursoAnterior.setLocalizedLabel(ENGLISH, "previous value name");
        this.nombreRecursoAnterior.setLocalizedLabel(SPANISH, "nombre del valor anterior");
        this.valorAparenteAnterior.setLocalizedDescription(ENGLISH, "formatted text representing the previous parameter value; only applies to update operations");
        this.valorAparenteAnterior.setLocalizedDescription(SPANISH, "texto con formato que representa el valor anterior del par\u00e1metro; solo aplica a operaciones de actualizaci\u00f3n");
        this.valorAparenteAnterior.setLocalizedLabel(ENGLISH, "previous value");
        this.valorAparenteAnterior.setLocalizedLabel(SPANISH, "valor anterior");
        this.diferenteValor.setLocalizedDescription(ENGLISH, "indicator that shows whether or not the value is different from the previous value; only applies to update operations");
        this.diferenteValor.setLocalizedDescription(SPANISH, "indicador que muestra si el valor es, o no, diferente al valor anterior; solo aplica a operaciones de actualizaci\u00f3n");
        this.diferenteValor.setLocalizedLabel(ENGLISH, "different");
        this.diferenteValor.setLocalizedLabel(SPANISH, "diferente");
        this.idClaseRecursoValor.setLocalizedLabel(ENGLISH, "resource class");
        this.idClaseRecursoValor.setLocalizedLabel(SPANISH, "clase de recurso");
        this.paginaRecurso.setLocalizedLabel(ENGLISH, "detail");
        this.paginaRecurso.setLocalizedLabel(SPANISH, "detalle");
        this.paginaRecurso.setLocalizedTooltip(ENGLISH, "open the detailed query page of the resource");
        this.paginaRecurso.setLocalizedTooltip(SPANISH, "abrir la p\u00e1gina de consulta detallada del recurso");
    }

    @Override
    protected void settleLinks() {
        super.settleLinks();
        this.linkForeignOwnerProperty(this.rastroFuncion.usuario);
        this.linkForeignSegmentProperty(this.rastroFuncion.usuario);
        this.linkForeignQueryProperty((Property)this.rastroFuncion.fechaHoraEjecucion);
        this.linkForeignQueryProperty((Property)this.rastroFuncion.funcion);
        this.linkForeignQueryProperty((Property)this.rastroFuncion.tipoFuncion);
        this.linkForeignQueryProperty((Property)this.rastroFuncion.codigoFuncion);
        this.linkForeignQueryProperty((Property)this.rastroFuncion.nombreFuncion);
        this.linkForeignQueryProperty((Property)this.rastroFuncion.codigoRecurso);
        this.linkForeignQueryProperty((Property)this.rastroFuncion.nombreRecurso);
        this.linkForeignQueryProperty((Property)this.rastroFuncion.codigoClaseRecursoValor);
        this.linkForeignQueryProperty((Property)this.rastroFuncion.nombreClaseRecursoValor);
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.biz = this.rastroFuncion.tipoFuncion.isIn(this.rastroFuncion.tipoFuncion.PROCEDIMIENTO_PARAMETROS, this.rastroFuncion.tipoFuncion.PROCESO);
        this.dml = this.rastroFuncion.tipoFuncion.isIn(this.rastroFuncion.tipoFuncion.CREACION, this.rastroFuncion.tipoFuncion.MODIFICACION, this.rastroFuncion.tipoFuncion.ELIMINACION);
        this.biz.setLocalizedCollectionLabel(ENGLISH, "Business Procedures and Processes");
        this.biz.setLocalizedCollectionLabel(SPANISH, "Procedimientos y Procesos de Negocio");
        this.biz.setLocalizedCollectionShortLabel(ENGLISH, "Business Operations");
        this.biz.setLocalizedCollectionShortLabel(SPANISH, "Operaciones de Negocio");
        this.dml.setLocalizedCollectionLabel(ENGLISH, "Registration Operations (Insert, Update and Delete)");
        this.dml.setLocalizedCollectionLabel(SPANISH, "Operaciones de Registro (Creaci\u00f3n, Modificaci\u00f3n y Eliminaci\u00f3n)");
        this.dml.setLocalizedCollectionShortLabel(ENGLISH, "Registration Operations");
        this.dml.setLocalizedCollectionShortLabel(SPANISH, "Operaciones de Registro");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.addSelectSegment(this.biz, this.dml);
        BooleanComparisonX modificacion = this.rastroFuncion.tipoFuncion.isEqualTo(this.rastroFuncion.tipoFuncion.MODIFICACION);
        this.valorAnterior.setRenderingFilter(modificacion);
        this.codigoRecursoAnterior.setRenderingFilter(modificacion);
        this.nombreRecursoAnterior.setRenderingFilter(modificacion);
        this.valorAparenteAnterior.setRenderingFilter(modificacion);
        this.diferenteValor.setRenderingFilter(modificacion);
    }

    @Override
    protected void settleViews() {
        ViewField vf014;
        ViewField vf013;
        ViewField vf012;
        ViewField vf011;
        ViewField vf010;
        ViewField vf009;
        ViewField vf008;
        ViewField vf007;
        ViewField vf006;
        ViewField vf005;
        ViewField vf004;
        ViewField vf003;
        ViewField vf002;
        super.settleViews();
        this.rastrosConParametros.setPageFormatClass(DefaultPageFormat.class);
        int controlGroupReportElementsWidth = 720;
        this.rastrosConParametros.newControlField(this.rastroFuncion);
        ViewField vf = this.rastrosConParametros.newHeadingField(this.rastroFuncion.fechaHoraEjecucion, this.rastroFuncion);
        vf.setPixels(720);
        vf = this.rastrosConParametros.newHeadingField(this.rastroFuncion.codigoUsuario, this.rastroFuncion);
        vf.setPixels(720);
        vf = this.rastrosConParametros.newHeadingField(this.rastroFuncion.nombreUsuario, this.rastroFuncion);
        vf.setPixels(720);
        vf = this.rastrosConParametros.newHeadingField(this.rastroFuncion.codigoFuncion, this.rastroFuncion);
        vf.setPixels(720);
        vf = this.rastrosConParametros.newHeadingField(this.rastroFuncion.nombreFuncion, this.rastroFuncion);
        vf.setPixels(720);
        vf = this.rastrosConParametros.newHeadingField(this.rastroFuncion.codigoRecurso, this.rastroFuncion);
        vf.setPixels(720);
        vf = this.rastrosConParametros.newHeadingField(this.rastroFuncion.nombreRecurso, this.rastroFuncion);
        vf.setPixels(720);
        vf = this.rastrosConParametros.newHeadingField(this.rastroFuncion.condicionEjeFun.codigo, this.rastroFuncion);
        vf.setPixels(720);
        vf = this.rastrosConParametros.newDetailField((Property)this.id, SortOption.ASC);
        vf.setPixels(0);
        vf = this.rastrosConParametros.newDetailField(this.parametro.nombreParametro);
        vf.setPixels(240);
        vf = this.rastrosConParametros.newDetailField(this.valorAparenteParametro);
        vf.setPixels(320);
        vf = this.rastrosConParametros.newDetailField(this.valorAparenteAnterior);
        vf.setPixels(320);
        vf = this.rastrosConParametros.newDetailField(this.diferenteValor);
        vf.setPixels(60);
        this.rastrosConParametros.setLocalizedLabel(ENGLISH, "Function Trail Parameters");
        this.rastrosConParametros.setLocalizedLabel(SPANISH, "Rastros de Par\u00e1metros de Funci\u00f3n");
        ViewField vf001 = this.rastrosConParametros.getField(this.rastroFuncion);
        if (vf001 != null) {
            vf001.setLocalizedLabel(ENGLISH, "function trail");
            vf001.setLocalizedLabel(SPANISH, "rastro de funci\u00f3n");
        }
        if ((vf002 = this.rastrosConParametros.getField(this.rastroFuncion.fechaHoraEjecucion)) != null) {
            vf002.setLocalizedLabel(ENGLISH, "timestamp");
            vf002.setLocalizedLabel(SPANISH, "fecha/hora");
        }
        if ((vf003 = this.rastrosConParametros.getField(this.rastroFuncion.codigoUsuario)) != null) {
            vf003.setLocalizedLabel(ENGLISH, "user");
            vf003.setLocalizedLabel(SPANISH, "usuario");
        }
        if ((vf004 = this.rastrosConParametros.getField(this.rastroFuncion.nombreUsuario)) != null) {
            vf004.setLocalizedLabel(ENGLISH, "user name");
            vf004.setLocalizedLabel(SPANISH, "nombre del usuario");
        }
        if ((vf005 = this.rastrosConParametros.getField(this.rastroFuncion.codigoFuncion)) != null) {
            vf005.setLocalizedLabel(ENGLISH, "function");
            vf005.setLocalizedLabel(SPANISH, "funci\u00f3n");
        }
        if ((vf006 = this.rastrosConParametros.getField(this.rastroFuncion.nombreFuncion)) != null) {
            vf006.setLocalizedLabel(ENGLISH, "function name");
            vf006.setLocalizedLabel(SPANISH, "nombre de la funci\u00f3n");
        }
        if ((vf007 = this.rastrosConParametros.getField(this.rastroFuncion.codigoRecurso)) != null) {
            vf007.setLocalizedLabel(ENGLISH, "resource");
            vf007.setLocalizedLabel(SPANISH, "recurso");
        }
        if ((vf008 = this.rastrosConParametros.getField(this.rastroFuncion.nombreRecurso)) != null) {
            vf008.setLocalizedLabel(ENGLISH, "resource name");
            vf008.setLocalizedLabel(SPANISH, "nombre del recurso");
        }
        if ((vf009 = this.rastrosConParametros.getField(this.rastroFuncion.condicionEjeFun.codigo)) != null) {
            vf009.setLocalizedLabel(ENGLISH, "condition");
            vf009.setLocalizedLabel(SPANISH, "condici\u00f3n");
        }
        if ((vf010 = this.rastrosConParametros.getField(this.id)) != null) {
            vf010.setLocalizedLabel(ENGLISH, "trail");
            vf010.setLocalizedLabel(SPANISH, "rastro");
        }
        if ((vf011 = this.rastrosConParametros.getField(this.parametro.nombreParametro)) != null) {
            vf011.setLocalizedLabel(ENGLISH, "parameter");
            vf011.setLocalizedLabel(SPANISH, "par\u00e1metro");
        }
        if ((vf012 = this.rastrosConParametros.getField(this.valorAparenteParametro)) != null) {
            vf012.setLocalizedLabel(ENGLISH, "value");
            vf012.setLocalizedLabel(SPANISH, "valor");
        }
        if ((vf013 = this.rastrosConParametros.getField(this.valorAparenteAnterior)) != null) {
            vf013.setLocalizedLabel(ENGLISH, "previous value");
            vf013.setLocalizedLabel(SPANISH, "valor anterior");
        }
        if ((vf014 = this.rastrosConParametros.getField(this.diferenteValor)) != null) {
            vf014.setLocalizedLabel(ENGLISH, "different");
            vf014.setLocalizedLabel(SPANISH, "diferente");
        }
    }

    @ReportOperationClass(viewField="rastrosConParametros")
    @OperationClass(access=OperationAccess.PROTECTED)
    public class EmitirInformeRastrosConParametros
    extends ReportOperation {
        @ParameterField(linkedColumn="fecha_hora_ejecucion_1", operator=StandardRelationalOp.GTEQ)
        protected TimestampParameter desde;
        @ParameterField(linkedColumn="fecha_hora_ejecucion_1", operator=StandardRelationalOp.LTEQ)
        protected TimestampParameter hasta;
        @ParameterField(linkedColumn="usuario_1")
        protected Usuario usuario;
        @ParameterField(linkedColumn="funcion_1")
        protected Funcion funcion;
        @ParameterField(linkedColumn="codigo_recurso_1")
        protected StringParameter codigoRecurso;
        @ParameterField(linkedField="diferenteValor")
        protected BooleanParameter diferente;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "generate function trail report with parameters");
            this.setLocalizedLabel(SPANISH, "generar informe de rastros con par\u00e1metros");
            this.setLocalizedShortLabel(ENGLISH, "function trail report with parameters");
            this.setLocalizedShortLabel(SPANISH, "informe de rastros con par\u00e1metros");
            this.setLocalizedDescription(ENGLISH, "issue a report of function execution audit trails with parameters");
            this.setLocalizedDescription(SPANISH, "emitir un informe de rastros de ejecuci\u00f3n de funci\u00f3n con sus par\u00e1metros");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.desde.setMinValue("2001-01-01");
            this.desde.setMaxValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
            this.hasta.setMinValue(this.desde);
            this.hasta.setMaxValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
            this.desde.setLocalizedDescription(ENGLISH, "date and time of the function execution");
            this.desde.setLocalizedDescription(SPANISH, "fecha y hora de la ejecuci\u00f3n de la funci\u00f3n");
            this.desde.setLocalizedLabel(ENGLISH, "from");
            this.desde.setLocalizedLabel(SPANISH, "desde");
            this.hasta.setLocalizedDescription(ENGLISH, "date and time of the function execution");
            this.hasta.setLocalizedDescription(SPANISH, "fecha y hora de la ejecuci\u00f3n de la funci\u00f3n");
            this.hasta.setLocalizedLabel(ENGLISH, "to");
            this.hasta.setLocalizedLabel(SPANISH, "hasta");
            this.usuario.setLocalizedDescription(ENGLISH, "user who executed the function");
            this.usuario.setLocalizedDescription(SPANISH, "usuario que ejecut\u00f3 la funci\u00f3n");
            this.usuario.setLocalizedLabel(ENGLISH, "user");
            this.usuario.setLocalizedLabel(SPANISH, "usuario");
            this.funcion.setLocalizedDescription(ENGLISH, "function");
            this.funcion.setLocalizedDescription(SPANISH, "funci\u00f3n");
            this.funcion.setLocalizedLabel(ENGLISH, "function");
            this.funcion.setLocalizedLabel(SPANISH, "funci\u00f3n");
            this.codigoRecurso.setLocalizedDescription(ENGLISH, "code of the resource on which the function was executed");
            this.codigoRecurso.setLocalizedDescription(SPANISH, "c\u00f3digo del recurso sobre el que se ejecut\u00f3 la funci\u00f3n");
            this.codigoRecurso.setLocalizedLabel(ENGLISH, "resource code");
            this.codigoRecurso.setLocalizedLabel(SPANISH, "c\u00f3digo del recurso");
            this.diferente.setLocalizedLabel(ENGLISH, "different");
            this.diferente.setLocalizedLabel(SPANISH, "diferente");
        }
    }

    @ExportOperationClass(viewField="rastrosConParametros")
    @OperationClass(access=OperationAccess.PROTECTED)
    public class ExportarArchivoRastrosConParametros
    extends ExportOperation {
        @ParameterField(linkedColumn="fecha_hora_ejecucion_1", operator=StandardRelationalOp.GTEQ)
        protected TimestampParameter desde;
        @ParameterField(linkedColumn="fecha_hora_ejecucion_1", operator=StandardRelationalOp.LTEQ)
        protected TimestampParameter hasta;
        @ParameterField(linkedColumn="usuario_1")
        protected Usuario usuario;
        @ParameterField(linkedColumn="funcion_1")
        protected Funcion funcion;
        @ParameterField(linkedColumn="codigo_recurso_1")
        protected StringParameter codigoRecurso;
        @ParameterField(linkedField="diferenteValor")
        protected BooleanParameter diferente;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "generate function trail file with parameters");
            this.setLocalizedLabel(SPANISH, "generar archivo de rastros con par\u00e1metros");
            this.setLocalizedShortLabel(ENGLISH, "function trail file with parameters");
            this.setLocalizedShortLabel(SPANISH, "archivo de rastros con par\u00e1metros");
            this.setLocalizedDescription(ENGLISH, "export a file of function execution audit trails with parameters");
            this.setLocalizedDescription(SPANISH, "exportar un archivo de rastros de ejecuci\u00f3n de funci\u00f3n con sus par\u00e1metros");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.desde.setMinValue("2001-01-01");
            this.desde.setMaxValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
            this.hasta.setMinValue(this.desde);
            this.hasta.setMaxValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
            this.desde.setLocalizedDescription(ENGLISH, "date and time of the function execution");
            this.desde.setLocalizedDescription(SPANISH, "fecha y hora de la ejecuci\u00f3n de la funci\u00f3n");
            this.desde.setLocalizedLabel(ENGLISH, "from");
            this.desde.setLocalizedLabel(SPANISH, "desde");
            this.hasta.setLocalizedDescription(ENGLISH, "date and time of the function execution");
            this.hasta.setLocalizedDescription(SPANISH, "fecha y hora de la ejecuci\u00f3n de la funci\u00f3n");
            this.hasta.setLocalizedLabel(ENGLISH, "to");
            this.hasta.setLocalizedLabel(SPANISH, "hasta");
            this.usuario.setLocalizedDescription(ENGLISH, "user who executed the function");
            this.usuario.setLocalizedDescription(SPANISH, "usuario que ejecut\u00f3 la funci\u00f3n");
            this.usuario.setLocalizedLabel(ENGLISH, "user");
            this.usuario.setLocalizedLabel(SPANISH, "usuario");
            this.funcion.setLocalizedDescription(ENGLISH, "function");
            this.funcion.setLocalizedDescription(SPANISH, "funci\u00f3n");
            this.funcion.setLocalizedLabel(ENGLISH, "function");
            this.funcion.setLocalizedLabel(SPANISH, "funci\u00f3n");
            this.codigoRecurso.setLocalizedDescription(ENGLISH, "code of the resource on which the function was executed");
            this.codigoRecurso.setLocalizedDescription(SPANISH, "c\u00f3digo del recurso sobre el que se ejecut\u00f3 la funci\u00f3n");
            this.codigoRecurso.setLocalizedLabel(ENGLISH, "resource code");
            this.codigoRecurso.setLocalizedLabel(SPANISH, "c\u00f3digo del recurso");
            this.diferente.setLocalizedLabel(ENGLISH, "different");
            this.diferente.setLocalizedLabel(SPANISH, "diferente");
        }
    }
}

