/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.operacion.basica;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Key;
import adalid.core.ProcessOperation;
import adalid.core.Tab;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityDocGen;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityReferenceDisplay;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.EntityWarnings;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.OwnerProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.ProcessOperationClass;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.SegmentProperty;
import adalid.core.annotations.StateProperty;
import adalid.core.annotations.StringField;
import adalid.core.annotations.UniformResourceLocator;
import adalid.core.annotations.UserProperty;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Checkpoint;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.EntityReferenceStyle;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.enums.SortOption;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.enums.UrlDisplayType;
import adalid.core.enums.UrlType;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.Segment;
import adalid.core.interfaces.State;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimestampProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.auditoria.RastroProceso;
import meta.entidad.comun.configuracion.basica.Funcion;
import meta.entidad.comun.control.acceso.Usuario;
import meta.entidad.comun.operacion.basica.CondicionTarea;
import meta.entidad.comun.operacion.basica.RecursoValor;

@EntityClass(base=Kleenean.TRUE, independent=Kleenean.TRUE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.FEMININE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntityDocGen(stateDiagram=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE, onload=SelectOnloadOption.EXECUTE, sortOption=SortOption.ASC)
@EntityInsertOperation(enabled=Kleenean.FALSE)
@EntityUpdateOperation(enabled=Kleenean.FALSE)
@EntityDeleteOperation(enabled=Kleenean.FALSE)
@EntityTableView(enabled=Kleenean.TRUE)
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE)
@EntityWarnings(aboutBusinessKey=Kleenean.FALSE)
public class TareaUsuario
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @ColumnField(nullable=Kleenean.FALSE, indexed=Kleenean.TRUE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public LongProperty tarea;
    @OwnerProperty
    @SegmentProperty
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public Usuario destinatario;
    @ColumnField(nullable=Kleenean.FALSE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE)
    @EntityReferenceDisplay(style=EntityReferenceStyle.NAME)
    public Funcion funcion;
    @ColumnField(calculable=Kleenean.TRUE)
    @PropertyField(table=Kleenean.FALSE)
    @StringField(maxLength=0)
    public StringProperty descripcionFuncion;
    @UniformResourceLocator(urlType=UrlType.INTERNAL, urlDisplayMode=DisplayMode.PROCESSING, urlDisplayType=UrlDisplayType.BUTTON)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.FALSE, search=Kleenean.FALSE, headertextless=Kleenean.TRUE)
    public StringProperty paginaFuncion;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idClaseRecursoValor;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.FALSE, report=Kleenean.FALSE, search=Kleenean.TRUE, heading=Kleenean.FALSE, overlay=Kleenean.FALSE)
    @StringField(maxLength=100)
    public StringProperty codigoClaseRecursoValor;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.FALSE, report=Kleenean.FALSE, search=Kleenean.TRUE, heading=Kleenean.FALSE, overlay=Kleenean.FALSE)
    @StringField(maxLength=100)
    public StringProperty nombreClaseRecursoValor;
    @ColumnField(nullable=Kleenean.TRUE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(hidden=Kleenean.TRUE)
    public RecursoValor recursoValor;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idRecursoValor;
    @ColumnField(indexed=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE, heading=Kleenean.FALSE, overlay=Kleenean.TRUE)
    public StringProperty codigoRecursoValor;
    @ColumnField(indexed=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public StringProperty nombreRecursoValor;
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.FALSE)
    @StringField(maxLength=0)
    public StringProperty descripcionRecursoValor;
    @UniformResourceLocator(urlType=UrlType.INTERNAL, urlDisplayType=UrlDisplayType.BUTTON)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.FALSE, search=Kleenean.FALSE, headertextless=Kleenean.TRUE)
    public StringProperty paginaRecurso;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    public Usuario responsable;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    public Usuario supervisor;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    public Usuario finalizador;
    @StateProperty
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public CondicionTarea condicion;
    @ColumnField(nullable=Kleenean.TRUE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(table=Kleenean.FALSE, report=Kleenean.FALSE)
    public RastroProceso rastroProceso;
    @UserProperty
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    public Usuario usuarioCondicion;
    @ColumnField(nullable=Kleenean.FALSE, indexed=Kleenean.TRUE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public TimestampProperty fechaHoraCondicion;
    @ColumnField(nullable=Kleenean.TRUE)
    public TimestampProperty fechaHoraAsignacion;
    @ColumnField(nullable=Kleenean.TRUE)
    public TimestampProperty fechaHoraAsuncion;
    @ColumnField(nullable=Kleenean.TRUE)
    public TimestampProperty fechaHoraRelevacion;
    @ColumnField(nullable=Kleenean.TRUE)
    public TimestampProperty fechaHoraAbandono;
    @ColumnField(nullable=Kleenean.TRUE)
    public TimestampProperty fechaHoraCancelacion;
    @ColumnField(nullable=Kleenean.TRUE)
    public TimestampProperty fechaHoraFinalizacion;
    @ColumnField(nullable=Kleenean.FALSE)
    public TimestampProperty fechaHoraRegistro;
    @ColumnField(nullable=Kleenean.TRUE)
    public TimestampProperty fechaHoraLimite;
    @ColumnField(nullable=Kleenean.TRUE)
    public IntegerProperty prioridad;
    protected Key key1;
    protected Key key2;
    protected Key key3;
    protected Tab descripcion;
    protected Tab participantes;
    protected Tab cronologia;
    protected Segment propiedadUsuarioActual;
    protected Segment responsabilidadUsuarioActual;
    protected Segment pendienteUsuarioActual;
    protected State disponible;
    protected State asignada;
    protected State asumible;
    protected State abandonable;
    protected State pendiente;
    protected State ejecutada;
    protected State cancelada;
    protected State finalizada;
    protected NotificarTareas notificarTareas;
    protected Asumir asumir;
    protected Abandonar abandonar;
    protected Asignar asignar;
    protected Relevar relevar;
    protected Cancelar cancelar;

    public TareaUsuario(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "task");
        this.setLocalizedLabel(SPANISH, "tarea");
        this.setLocalizedCollectionLabel(ENGLISH, "Tasks");
        this.setLocalizedCollectionLabel(SPANISH, "Tareas");
        this.setLocalizedDescription(ENGLISH, "Each instance of " + this.b("Tasks") + " represents a task notification.");
        this.setLocalizedDescription(SPANISH, "Cada instancia de " + this.b("Tareas") + " representa una notificaci\u00f3n de tarea.");
        this.setLocalizedShortDescription(ENGLISH, "task notification");
        this.setLocalizedShortDescription(SPANISH, "notificaci\u00f3n de tarea");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.descripcionFuncion.setCalculableValueExpression(this.funcion.descripcionFuncion);
        this.condicion.setInitialValue(this.condicion.DISPONIBLE);
        this.condicion.setDefaultValue(this.condicion.DISPONIBLE);
        this.fechaHoraCondicion.setInitialValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.fechaHoraCondicion.setDefaultValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.fechaHoraRegistro.setInitialValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.fechaHoraRegistro.setDefaultValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.setGraphicImageExpressions();
        this.tarea.setLocalizedLabel(ENGLISH, "task");
        this.tarea.setLocalizedLabel(SPANISH, "tarea");
        this.destinatario.setLocalizedLabel(ENGLISH, "recipient user");
        this.destinatario.setLocalizedLabel(SPANISH, "usuario destinatario");
        this.destinatario.setLocalizedShortLabel(ENGLISH, "recipient");
        this.destinatario.setLocalizedShortLabel(SPANISH, "destinatario");
        this.destinatario.setLocalizedShortDescription(ENGLISH, "task notification recipient");
        this.destinatario.setLocalizedShortDescription(SPANISH, "destinatario de la notificaci\u00f3n de tarea");
        this.destinatario.setLocalizedTooltip(ENGLISH, "user code of the task notification recipient");
        this.destinatario.setLocalizedTooltip(SPANISH, "c\u00f3digo de usuario del destinatario de la notificaci\u00f3n de tarea");
        this.destinatario.codigoUsuario.setLocalizedShortLabel(ENGLISH, "recipient code");
        this.destinatario.codigoUsuario.setLocalizedShortLabel(SPANISH, "destinatario");
        this.funcion.setLocalizedLabel(ENGLISH, "function");
        this.funcion.setLocalizedLabel(SPANISH, "funci\u00f3n");
        this.funcion.codigoFuncion.setLocalizedShortLabel(ENGLISH, "function code");
        this.funcion.codigoFuncion.setLocalizedShortLabel(SPANISH, "funci\u00f3n");
        this.descripcionFuncion.setLocalizedLabel(ENGLISH, "function description");
        this.descripcionFuncion.setLocalizedLabel(SPANISH, "descripci\u00f3n de la funci\u00f3n");
        this.paginaFuncion.setLocalizedLabel(ENGLISH, "function page");
        this.paginaFuncion.setLocalizedLabel(SPANISH, "p\u00e1gina de la funci\u00f3n");
        this.paginaFuncion.setLocalizedTooltip(ENGLISH, "open the function's processing page");
        this.paginaFuncion.setLocalizedTooltip(SPANISH, "abrir la p\u00e1gina de procesamiento de la funci\u00f3n");
        this.idClaseRecursoValor.setLocalizedLabel(ENGLISH, "resource class");
        this.idClaseRecursoValor.setLocalizedLabel(SPANISH, "clase de recurso");
        this.codigoClaseRecursoValor.setLocalizedLabel(ENGLISH, "resource class");
        this.codigoClaseRecursoValor.setLocalizedLabel(SPANISH, "clase de recurso");
        this.nombreClaseRecursoValor.setLocalizedLabel(ENGLISH, "resource class name");
        this.nombreClaseRecursoValor.setLocalizedLabel(SPANISH, "nombre de la clase de recurso");
        this.recursoValor.setLocalizedLabel(ENGLISH, "resource");
        this.recursoValor.setLocalizedLabel(SPANISH, "recurso");
        this.idRecursoValor.setLocalizedLabel(ENGLISH, "resource value");
        this.idRecursoValor.setLocalizedLabel(SPANISH, "recurso valor");
        this.codigoRecursoValor.setLocalizedLabel(ENGLISH, "resource");
        this.codigoRecursoValor.setLocalizedLabel(SPANISH, "recurso");
        this.nombreRecursoValor.setLocalizedLabel(ENGLISH, "resource name");
        this.nombreRecursoValor.setLocalizedLabel(SPANISH, "nombre del recurso");
        this.descripcionRecursoValor.setLocalizedLabel(ENGLISH, "resource description");
        this.descripcionRecursoValor.setLocalizedLabel(SPANISH, "descripci\u00f3n del recurso");
        this.paginaRecurso.setLocalizedLabel(ENGLISH, "resource page");
        this.paginaRecurso.setLocalizedLabel(SPANISH, "p\u00e1gina del recurso");
        this.paginaRecurso.setLocalizedTooltip(ENGLISH, "open the resource's registration page");
        this.paginaRecurso.setLocalizedTooltip(SPANISH, "abrir la p\u00e1gina de registro del recurso");
        this.responsable.setLocalizedLabel(ENGLISH, "responsible user");
        this.responsable.setLocalizedLabel(SPANISH, "usuario responsable");
        this.responsable.setLocalizedShortLabel(ENGLISH, "responsible");
        this.responsable.setLocalizedShortLabel(SPANISH, "responsable");
        this.responsable.setLocalizedShortDescription(ENGLISH, "responsible for carrying out the task");
        this.responsable.setLocalizedShortDescription(SPANISH, "responsable de la ejecuci\u00f3n de la tarea");
        this.responsable.setLocalizedTooltip(ENGLISH, "user code of the responsible for carrying out the task");
        this.responsable.setLocalizedTooltip(SPANISH, "c\u00f3digo de usuario del responsable de la ejecuci\u00f3n de la tarea");
        this.supervisor.setLocalizedLabel(ENGLISH, "supervising user");
        this.supervisor.setLocalizedLabel(SPANISH, "usuario supervisor");
        this.supervisor.setLocalizedShortLabel(ENGLISH, "supervisor");
        this.supervisor.setLocalizedShortLabel(SPANISH, "supervisor");
        this.supervisor.setLocalizedShortDescription(ENGLISH, "person who assigns responsibility to carry out the task");
        this.supervisor.setLocalizedShortDescription(SPANISH, "persona que asigna la responsabilidad de ejecutar la tarea");
        this.supervisor.setLocalizedTooltip(ENGLISH, "user code of the person who assigns responsibility to carry out the task");
        this.supervisor.setLocalizedTooltip(SPANISH, "c\u00f3digo de usuario de la persona que asigna la responsabilidad de ejecutar la tarea");
        this.finalizador.setLocalizedLabel(ENGLISH, "executing user");
        this.finalizador.setLocalizedLabel(SPANISH, "usuario finalizador");
        this.finalizador.setLocalizedShortLabel(ENGLISH, "executor");
        this.finalizador.setLocalizedShortLabel(SPANISH, "finalizador");
        this.finalizador.setLocalizedShortDescription(ENGLISH, "person who completes (executes or cancels) the task");
        this.finalizador.setLocalizedShortDescription(SPANISH, "persona que finaliza (ejecuta o cancela) la tarea");
        this.finalizador.setLocalizedTooltip(ENGLISH, "user code of the person who completes (executes or cancels) the task");
        this.finalizador.setLocalizedTooltip(SPANISH, "c\u00f3digo de usuario de la persona que finaliza (ejecuta o cancela) la tarea");
        this.condicion.setLocalizedLabel(ENGLISH, "condition");
        this.condicion.setLocalizedLabel(SPANISH, "condici\u00f3n");
        this.rastroProceso.setLocalizedDescription(ENGLISH, "audit trail of the execution of the business process corresponding to the task");
        this.rastroProceso.setLocalizedDescription(SPANISH, "rastro de auditor\u00eda de la ejecuci\u00f3n del proceso de negocio correspondiente a la tarea");
        this.rastroProceso.setLocalizedLabel(ENGLISH, "process execution audit trail");
        this.rastroProceso.setLocalizedLabel(SPANISH, "rastro de ejecuci\u00f3n del proceso");
        this.rastroProceso.setLocalizedShortLabel(ENGLISH, "process audit trail");
        this.rastroProceso.setLocalizedShortLabel(SPANISH, "rastro del proceso");
        this.usuarioCondicion.setLocalizedLabel(ENGLISH, "transition user");
        this.usuarioCondicion.setLocalizedLabel(SPANISH, "usuario transici\u00f3n");
        this.usuarioCondicion.setLocalizedShortLabel(ENGLISH, "user");
        this.usuarioCondicion.setLocalizedShortLabel(SPANISH, "usuario");
        this.usuarioCondicion.setLocalizedDescription(ENGLISH, "user who executed the operation that caused the last condition change");
        this.usuarioCondicion.setLocalizedDescription(SPANISH, "usuario que ejecut\u00f3 la operaci\u00f3n que produjo el \u00faltimo cambio de condici\u00f3n");
        this.fechaHoraCondicion.setLocalizedLabel(ENGLISH, "condition timestamp");
        this.fechaHoraCondicion.setLocalizedLabel(SPANISH, "fecha/hora condici\u00f3n");
        this.fechaHoraCondicion.setLocalizedShortLabel(ENGLISH, "timestamp");
        this.fechaHoraCondicion.setLocalizedShortLabel(SPANISH, "fecha/hora");
        this.fechaHoraCondicion.setLocalizedDescription(ENGLISH, "timestamp of the last condition change");
        this.fechaHoraCondicion.setLocalizedDescription(SPANISH, "fecha y hora del \u00faltimo cambio de condici\u00f3n");
        this.fechaHoraAsignacion.setLocalizedLabel(ENGLISH, "assignment timestamp");
        this.fechaHoraAsignacion.setLocalizedLabel(SPANISH, "fecha/hora asignaci\u00f3n");
        this.fechaHoraAsignacion.setLocalizedShortLabel(ENGLISH, "assignment");
        this.fechaHoraAsignacion.setLocalizedShortLabel(SPANISH, "asignaci\u00f3n");
        this.fechaHoraAsuncion.setLocalizedLabel(ENGLISH, "assumption timestamp");
        this.fechaHoraAsuncion.setLocalizedLabel(SPANISH, "fecha/hora asunci\u00f3n");
        this.fechaHoraAsuncion.setLocalizedShortLabel(ENGLISH, "assumption");
        this.fechaHoraAsuncion.setLocalizedShortLabel(SPANISH, "asunci\u00f3n");
        this.fechaHoraRelevacion.setLocalizedLabel(ENGLISH, "relief timestamp");
        this.fechaHoraRelevacion.setLocalizedLabel(SPANISH, "fecha/hora relevaci\u00f3n");
        this.fechaHoraRelevacion.setLocalizedShortLabel(ENGLISH, "relief");
        this.fechaHoraRelevacion.setLocalizedShortLabel(SPANISH, "relevaci\u00f3n");
        this.fechaHoraAbandono.setLocalizedLabel(ENGLISH, "abandonment timestamp");
        this.fechaHoraAbandono.setLocalizedLabel(SPANISH, "fecha/hora abandono");
        this.fechaHoraAbandono.setLocalizedShortLabel(ENGLISH, "abandonment");
        this.fechaHoraAbandono.setLocalizedShortLabel(SPANISH, "abandono");
        this.fechaHoraCancelacion.setLocalizedLabel(ENGLISH, "cancellation timestamp");
        this.fechaHoraCancelacion.setLocalizedLabel(SPANISH, "fecha/hora cancelaci\u00f3n");
        this.fechaHoraCancelacion.setLocalizedShortLabel(ENGLISH, "cancellation");
        this.fechaHoraCancelacion.setLocalizedShortLabel(SPANISH, "cancelaci\u00f3n");
        this.fechaHoraFinalizacion.setLocalizedLabel(ENGLISH, "completion timestamp");
        this.fechaHoraFinalizacion.setLocalizedLabel(SPANISH, "fecha/hora finalizaci\u00f3n");
        this.fechaHoraFinalizacion.setLocalizedShortLabel(ENGLISH, "completion");
        this.fechaHoraFinalizacion.setLocalizedShortLabel(SPANISH, "finalizaci\u00f3n");
        this.fechaHoraRegistro.setLocalizedLabel(ENGLISH, "registration timestamp");
        this.fechaHoraRegistro.setLocalizedLabel(SPANISH, "fecha/hora registro");
        this.fechaHoraRegistro.setLocalizedShortLabel(ENGLISH, "registration");
        this.fechaHoraRegistro.setLocalizedShortLabel(SPANISH, "registro");
        this.fechaHoraLimite.setLocalizedLabel(ENGLISH, "deadline");
        this.fechaHoraLimite.setLocalizedLabel(SPANISH, "fecha/hora l\u00edmite");
        this.fechaHoraLimite.setLocalizedShortLabel(ENGLISH, "deadline");
        this.fechaHoraLimite.setLocalizedShortLabel(SPANISH, "fecha/hora l\u00edmite");
        this.prioridad.setLocalizedLabel(ENGLISH, "priority");
        this.prioridad.setLocalizedLabel(SPANISH, "prioridad");
    }

    void setGraphicImageExpressions() {
    }

    @Override
    protected void settleLinks() {
        super.settleLinks();
    }

    @Override
    protected void settleKeys() {
        super.settleKeys();
        this.key1.newKeyField((Property)this.tarea);
        this.key2.newKeyField(this.condicion, this.fechaHoraLimite, this.tarea, this.destinatario);
        this.key3.newKeyField(this.idClaseRecursoValor, this.recursoValor);
        this.setOrderBy(this.key2);
    }

    @Override
    protected void settleTabs() {
        super.settleTabs();
        this.descripcion.newTabField(this.funcion, this.descripcionFuncion, this.paginaFuncion, this.codigoClaseRecursoValor, this.nombreClaseRecursoValor, this.recursoValor, this.codigoRecursoValor, this.nombreRecursoValor, this.descripcionRecursoValor, this.paginaRecurso);
        this.descripcion.newTabField((Property)this.condicion);
        this.descripcion.newTabField((Property)this.rastroProceso);
        this.descripcion.newTabField((Property)this.fechaHoraCondicion);
        this.descripcion.newTabField(this.fechaHoraLimite, this.prioridad);
        this.participantes.newTabField(this.responsable, this.supervisor, this.finalizador);
        this.cronologia.newTabField((Property)this.condicion);
        this.cronologia.newTabField((Property)this.rastroProceso);
        this.cronologia.newTabField(this.usuarioCondicion, this.fechaHoraCondicion, this.fechaHoraRegistro, this.fechaHoraAsignacion, this.fechaHoraAsuncion, this.fechaHoraRelevacion, this.fechaHoraAbandono, this.fechaHoraCancelacion, this.fechaHoraFinalizacion);
        this.descripcion.setLocalizedLabel(ENGLISH, "description");
        this.descripcion.setLocalizedLabel(SPANISH, "descripci\u00f3n");
        this.participantes.setLocalizedLabel(ENGLISH, "participants");
        this.participantes.setLocalizedLabel(SPANISH, "participantes");
        this.cronologia.setLocalizedLabel(ENGLISH, "chronology");
        this.cronologia.setLocalizedLabel(SPANISH, "cronologia");
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.propiedadUsuarioActual = this.destinatario.id.isEqualTo(CURRENT_USER_ID);
        this.responsabilidadUsuarioActual = this.responsable.isNotNull().and(this.responsable.id.isEqualTo(CURRENT_USER_ID));
        this.disponible = this.condicion.isEqualTo(this.condicion.DISPONIBLE);
        this.asignada = this.condicion.isEqualTo(this.condicion.ASIGNADA);
        this.asumible = this.disponible.and(this.propiedadUsuarioActual);
        this.abandonable = this.asignada.and(this.propiedadUsuarioActual).and(this.responsabilidadUsuarioActual);
        this.pendiente = this.condicion.isIn(this.condicion.DISPONIBLE, this.condicion.ASIGNADA);
        this.ejecutada = this.condicion.isEqualTo(this.condicion.EJECUTADA);
        this.cancelada = this.condicion.isEqualTo(this.condicion.CANCELADA);
        this.finalizada = this.condicion.isIn(this.condicion.EJECUTADA, this.condicion.CANCELADA);
        this.pendienteUsuarioActual = this.propiedadUsuarioActual.and(this.pendiente);
        this.propiedadUsuarioActual.setLocalizedCollectionLabel(ENGLISH, "all task notifications addressed to the current user");
        this.propiedadUsuarioActual.setLocalizedCollectionLabel(SPANISH, "todas las notificaciones de tareas dirigidas al usuario actual");
        this.propiedadUsuarioActual.setLocalizedCollectionShortLabel(ENGLISH, "My tasks");
        this.propiedadUsuarioActual.setLocalizedCollectionShortLabel(SPANISH, "Mis tareas");
        this.propiedadUsuarioActual.setLocalizedDescription(ENGLISH, "the notification is addressed to the current user");
        this.propiedadUsuarioActual.setLocalizedDescription(SPANISH, "la notificaci\u00f3n est\u00e1 dirigida al usuario actual");
        this.propiedadUsuarioActual.setLocalizedErrorMessage(ENGLISH, "the notification is addressed to another user");
        this.propiedadUsuarioActual.setLocalizedErrorMessage(SPANISH, "la notificaci\u00f3n est\u00e1 dirigida a otro usuario");
        this.pendienteUsuarioActual.setLocalizedCollectionLabel(ENGLISH, "all pending task notifications addressed to the current user");
        this.pendienteUsuarioActual.setLocalizedCollectionLabel(SPANISH, "todas las notificaciones de tareas pendientes dirigidas al usuario actual");
        this.pendienteUsuarioActual.setLocalizedCollectionShortLabel(ENGLISH, "My pending tasks");
        this.pendienteUsuarioActual.setLocalizedCollectionShortLabel(SPANISH, "Mis tareas pendientes");
        this.pendienteUsuarioActual.setLocalizedDescription(ENGLISH, "the notification is addressed to the current user and the task has not been executed or canceled");
        this.pendienteUsuarioActual.setLocalizedDescription(SPANISH, "la notificaci\u00f3n est\u00e1 dirigida al usuario actual y la tarea est\u00e1 pendiente");
        this.pendienteUsuarioActual.setLocalizedErrorMessage(ENGLISH, "the notification is addressed to another user or the task has already been executed or canceled");
        this.pendienteUsuarioActual.setLocalizedErrorMessage(SPANISH, "la notificaci\u00f3n est\u00e1 dirigida a otro usuario o la tarea est\u00e1 ejecutada o cancelada");
        this.responsabilidadUsuarioActual.setLocalizedCollectionLabel(ENGLISH, "all task notifications for which the current user is or was responsible");
        this.responsabilidadUsuarioActual.setLocalizedCollectionLabel(SPANISH, "todas las notificaciones de tareas de las que el usuario actual es o fue el responsable");
        this.responsabilidadUsuarioActual.setLocalizedCollectionShortLabel(ENGLISH, "My responsibilities");
        this.responsabilidadUsuarioActual.setLocalizedCollectionShortLabel(SPANISH, "Mis responsabilidades");
        this.responsabilidadUsuarioActual.setLocalizedDescription(ENGLISH, "the current user is responsible for carrying out the task");
        this.responsabilidadUsuarioActual.setLocalizedDescription(SPANISH, "el usuario actual es el responsable de la ejecuci\u00f3n de la tarea");
        this.responsabilidadUsuarioActual.setLocalizedErrorMessage(ENGLISH, "the current user is not responsible for carrying out the task");
        this.responsabilidadUsuarioActual.setLocalizedErrorMessage(SPANISH, "el usuario actual no es el responsable de la ejecuci\u00f3n de la tarea");
        this.disponible.setLocalizedDescription(ENGLISH, "the task is available");
        this.disponible.setLocalizedDescription(SPANISH, "la tarea est\u00e1 disponible");
        this.disponible.setLocalizedErrorMessage(ENGLISH, "the task is not available");
        this.disponible.setLocalizedErrorMessage(SPANISH, "la tarea no est\u00e1 disponible");
        this.asignada.setLocalizedDescription(ENGLISH, "the task is assigned");
        this.asignada.setLocalizedDescription(SPANISH, "la tarea est\u00e1 asignada");
        this.asignada.setLocalizedErrorMessage(ENGLISH, "the task is not assigned or it has already been executed or canceled");
        this.asignada.setLocalizedErrorMessage(SPANISH, "la tarea no est\u00e1 asignada o est\u00e1 ejecutada o cancelada");
        this.asumible.setLocalizedDescription(ENGLISH, "the task is available and the notification is addressed to the current user");
        this.asumible.setLocalizedDescription(SPANISH, "la tarea est\u00e1 disponible y la notificaci\u00f3n est\u00e1 dirigida al usuario actual");
        this.abandonable.setLocalizedDescription(ENGLISH, "the task is assigned and the notification is addressed to the current user and the current user is responsible for carrying out the task");
        this.abandonable.setLocalizedDescription(SPANISH, "la tarea est\u00e1 asignada y la notificaci\u00f3n est\u00e1 dirigida al usuario actual y el usuario actual es el responsable de la ejecuci\u00f3n de la tarea");
        this.pendiente.setLocalizedCollectionLabel(ENGLISH, "all notifications of tasks that have not been executed or canceled");
        this.pendiente.setLocalizedCollectionLabel(SPANISH, "todas las notificaciones de tareas que no se han ejecutado o cancelado");
        this.pendiente.setLocalizedCollectionShortLabel(ENGLISH, "Pending tasks");
        this.pendiente.setLocalizedCollectionShortLabel(SPANISH, "Tareas pendientes");
        this.pendiente.setLocalizedDescription(ENGLISH, "the task has not been executed or canceled");
        this.pendiente.setLocalizedDescription(SPANISH, "la tarea no est\u00e1 ejecutada ni cancelada");
        this.pendiente.setLocalizedErrorMessage(ENGLISH, "the task has already been executed or canceled");
        this.pendiente.setLocalizedErrorMessage(SPANISH, "la tarea est\u00e1 ejecutada o cancelada");
        this.ejecutada.setLocalizedDescription(ENGLISH, "the task is executed");
        this.ejecutada.setLocalizedDescription(SPANISH, "la tarea est\u00e1 ejecutada");
        this.ejecutada.setLocalizedErrorMessage(ENGLISH, "the task is not executed");
        this.ejecutada.setLocalizedErrorMessage(SPANISH, "la tarea no est\u00e1 ejecutada");
        this.cancelada.setLocalizedDescription(ENGLISH, "the task is canceled");
        this.cancelada.setLocalizedDescription(SPANISH, "la tarea est\u00e1 cancelada");
        this.cancelada.setLocalizedErrorMessage(ENGLISH, "the task is not canceled");
        this.cancelada.setLocalizedErrorMessage(SPANISH, "la tarea no est\u00e1 cancelada");
        this.finalizada.setLocalizedCollectionLabel(ENGLISH, "all notifications of tasks that have been executed or canceled");
        this.finalizada.setLocalizedCollectionLabel(SPANISH, "todas las notificaciones de tareas que se han ejecutado o cancelado");
        this.finalizada.setLocalizedCollectionShortLabel(ENGLISH, "Finished tasks");
        this.finalizada.setLocalizedCollectionShortLabel(SPANISH, "Tareas finalizadas");
        this.finalizada.setLocalizedDescription(ENGLISH, "the task is executed or canceled");
        this.finalizada.setLocalizedDescription(SPANISH, "la tarea est\u00e1 ejecutada o cancelada");
        this.finalizada.setLocalizedErrorMessage(ENGLISH, "the task is not executed or canceled");
        this.finalizada.setLocalizedErrorMessage(SPANISH, "la tarea no est\u00e1 ejecutada ni cancelada");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.addSelectSegment((Segment)this.pendiente, true);
        this.addSelectSegment((Segment)this.finalizada);
        this.addSelectSegment(this.propiedadUsuarioActual, this.pendienteUsuarioActual, this.responsabilidadUsuarioActual);
        this.setSelectFilter(this.responsable.isNullOrEqualTo(this.destinatario));
        this.rastroProceso.setRenderingFilter(this.rastroProceso.isNotNull());
    }

    @Override
    protected void settleOperations() {
        super.settleOperations();
        this.asignar.addTransition(this.disponible, this.asignada);
        this.relevar.addTransition(this.asignada, this.disponible);
        this.asumir.addTransition(this.asumible, this.abandonable);
        this.abandonar.addTransition(this.abandonable, this.disponible);
        this.cancelar.addTransition(this.pendiente, this.cancelada);
    }

    @OperationClass(access=OperationAccess.PROTECTED, confirmation=Kleenean.TRUE)
    @ProcessOperationClass
    public class Cancelar
    extends ProcessOperation {
        @InstanceReference
        protected TareaUsuario tarea;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "cancel");
            this.setLocalizedLabel(SPANISH, "cancelar");
            this.setLocalizedDescription(ENGLISH, "cancel all notifications of a task");
            this.setLocalizedDescription(SPANISH, "cancelar todas las notificaciones de una tarea");
            this.setLocalizedSuccessMessage(ENGLISH, "all task's notifications were canceled");
            this.setLocalizedSuccessMessage(SPANISH, "se cancelaron todas las notificaciones de la tarea");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.tarea.setLocalizedLabel(ENGLISH, "task");
            this.tarea.setLocalizedLabel(SPANISH, "tarea");
        }
    }

    @OperationClass(access=OperationAccess.PROTECTED)
    @ProcessOperationClass
    public class Relevar
    extends ProcessOperation {
        @InstanceReference
        protected TareaUsuario tarea;
        protected Check check101;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "relieve");
            this.setLocalizedLabel(SPANISH, "relevar");
            this.setLocalizedDescription(ENGLISH, "relieve of the responsibility for carrying out a task");
            this.setLocalizedDescription(SPANISH, "relevar de la responsabilidad de llevar a cabo una tarea");
            this.setLocalizedSuccessMessage(ENGLISH, "the responsibility for carrying out the task was relieved");
            this.setLocalizedSuccessMessage(SPANISH, "se relev\u00f3 la responsabilidad de llevar a cabo la tarea");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.tarea.setLocalizedLabel(ENGLISH, "task");
            this.tarea.setLocalizedLabel(SPANISH, "tarea");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.tarea.destinatario.id.isNotEqualTo(CURRENT_USER_ID);
            this.check101.setCheckpoint(Checkpoint.USER_INTERFACE);
            this.check101.setLocalizedDescription(ENGLISH, "to relieve a task, notification must not be addressed to the user");
            this.check101.setLocalizedDescription(SPANISH, "para relevar una tarea, la notificacion no debe estar dirigida al usuario");
            this.check101.setLocalizedErrorMessage(ENGLISH, "notification is addressed to your user");
            this.check101.setLocalizedErrorMessage(SPANISH, "la notificaci\u00f3n est\u00e1 dirigida a su usuario");
        }
    }

    @OperationClass(access=OperationAccess.PROTECTED)
    @ProcessOperationClass
    public class Asignar
    extends ProcessOperation {
        @InstanceReference
        protected TareaUsuario tarea;
        protected Check check101;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "assign");
            this.setLocalizedLabel(SPANISH, "asignar");
            this.setLocalizedDescription(ENGLISH, "assign the responsibility for carrying out a task");
            this.setLocalizedDescription(SPANISH, "asignar la responsabilidad de llevar a cabo una tarea");
            this.setLocalizedSuccessMessage(ENGLISH, "the responsibility for carrying out the task was assigned");
            this.setLocalizedSuccessMessage(SPANISH, "se asign\u00f3 la responsabilidad de llevar a cabo la tarea");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.tarea.setLocalizedLabel(ENGLISH, "task");
            this.tarea.setLocalizedLabel(SPANISH, "tarea");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.tarea.destinatario.id.isNotEqualTo(CURRENT_USER_ID);
            this.check101.setCheckpoint(Checkpoint.USER_INTERFACE);
            this.check101.setLocalizedDescription(ENGLISH, "to assign a task, notification must not be addressed to the user");
            this.check101.setLocalizedDescription(SPANISH, "para asignar una tarea, la notificacion no debe estar dirigida al usuario");
            this.check101.setLocalizedErrorMessage(ENGLISH, "notification is addressed to your user");
            this.check101.setLocalizedErrorMessage(SPANISH, "la notificaci\u00f3n est\u00e1 dirigida a su usuario");
        }
    }

    @OperationClass(access=OperationAccess.RESTRICTED)
    @ProcessOperationClass
    public class Abandonar
    extends ProcessOperation {
        @InstanceReference
        protected TareaUsuario tarea;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "abandon");
            this.setLocalizedLabel(SPANISH, "abandonar");
            this.setLocalizedDescription(ENGLISH, "give up the responsibility for carrying out a task");
            this.setLocalizedDescription(SPANISH, "abandonar la responsabilidad de llevar a cabo una tarea");
            this.setLocalizedSuccessMessage(ENGLISH, "the responsibility for carrying out the task was abandoned");
            this.setLocalizedSuccessMessage(SPANISH, "se abandon\u00f3 la responsabilidad de llevar a cabo la tarea");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.tarea.setLocalizedLabel(ENGLISH, "task");
            this.tarea.setLocalizedLabel(SPANISH, "tarea");
        }
    }

    @OperationClass(access=OperationAccess.RESTRICTED)
    @ProcessOperationClass
    public class Asumir
    extends ProcessOperation {
        @InstanceReference
        protected TareaUsuario tarea;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "assume");
            this.setLocalizedLabel(SPANISH, "asumir");
            this.setLocalizedDescription(ENGLISH, "assume the responsibility for carrying out a task");
            this.setLocalizedDescription(SPANISH, "asumir la responsabilidad de llevar a cabo una tarea");
            this.setLocalizedSuccessMessage(ENGLISH, "the responsibility for carrying out the task was assumed");
            this.setLocalizedSuccessMessage(SPANISH, "se asumi\u00f3 la responsabilidad de llevar a cabo la tarea");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.tarea.setLocalizedLabel(ENGLISH, "task");
            this.tarea.setLocalizedLabel(SPANISH, "tarea");
        }
    }

    @OperationClass(access=OperationAccess.PRIVATE)
    @ProcessOperationClass(bpl=Kleenean.FALSE, sql=Kleenean.FALSE)
    public class NotificarTareas
    extends ProcessOperation {
        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "notify users");
            this.setLocalizedLabel(SPANISH, "notificar usuarios");
            this.setLocalizedDescription(ENGLISH, "send task notifications to corresponding users");
            this.setLocalizedDescription(SPANISH, "enviar notificaciones de tareas a los usuarios correspondientes");
        }
    }
}

