/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.tools.svgtranscoder.api;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Objects;
import java.util.stream.Stream;
import org.pushingpixels.radiance.tools.svgtranscoder.api.LanguageRenderer;
import org.pushingpixels.radiance.tools.svgtranscoder.api.SvgBatchBaseConverter;
import org.pushingpixels.radiance.tools.svgtranscoder.api.java.JavaLanguageRenderer;
import org.pushingpixels.radiance.tools.svgtranscoder.api.kotlin.KotlinLanguageRenderer;

public class SvgBatchConverter
extends SvgBatchBaseConverter {
    public static void main(String[] args) throws IOException {
        String outputFileNameExtension;
        LanguageRenderer languageRenderer;
        if (args.length < 4) {
            System.out.println("=== Usage ===");
            Stream.of("java " + SvgBatchConverter.class.getCanonicalName(), "  sourceFolder=xyz - points to a folder with SVG images", "  outputPackageName=xyz - the package name for the transcoded classes", "  templateFile=xyz - the template file for creating the transcoded classes", "  outputLanguage=java|kotlin - the language for the transcoded classes", "  outputFolder=xyz - optional location of output files. If not specified, output files will be placed in the 'sourceFolder'", "  outputClassNamePrefix=xyz - optional prefix for the class name of each transcoded class").forEach(System.out::println);
            System.out.println("Check the documentation for the parameters to pass");
            System.exit(1);
        }
        SvgBatchConverter converter = new SvgBatchConverter();
        String sourceFolderName = converter.getInputArgument(args, "sourceFolder", null);
        Objects.requireNonNull(sourceFolderName, "Missing source folder. Check the documentation for the parameters to pass");
        String outputPackageName = converter.getInputArgument(args, "outputPackageName", null);
        Objects.requireNonNull(outputPackageName, "Missing output package name. Check the documentation for the parameters to pass");
        String templateFile = converter.getInputArgument(args, "templateFile", null);
        Objects.requireNonNull(templateFile, "Missing template file. Check the documentation for the parameters to pass");
        String outputLanguage = converter.getInputArgument(args, "outputLanguage", null);
        Objects.requireNonNull(outputLanguage, "Missing output language. Check the documentation for the parameters to pass");
        if ("java".equals(outputLanguage)) {
            languageRenderer = new JavaLanguageRenderer();
            outputFileNameExtension = ".java";
        } else if ("kotlin".equals(outputLanguage)) {
            languageRenderer = new KotlinLanguageRenderer();
            outputFileNameExtension = ".kt";
        } else {
            throw new IllegalArgumentException("Output language must be either Java or Kotlin. Check the documentation for the parameters to pass");
        }
        String outputClassNamePrefix = converter.getInputArgument(args, "outputClassNamePrefix", "");
        String outputFolderName = converter.getInputArgument(args, "outputFolder", sourceFolderName);
        File inputFolder = new File(sourceFolderName);
        if (!inputFolder.exists()) {
            throw new NoSuchFileException(sourceFolderName);
        }
        File outputFolder = new File(outputFolderName);
        if (!outputFolder.exists()) {
            throw new NoSuchFileException(outputFolderName);
        }
        System.out.println("******************************************************************************");
        System.out.println("Processing");
        System.out.println("\tsource folder: " + sourceFolderName);
        System.out.println("\tpackage name: " + outputPackageName);
        System.out.println("\toutput language: " + outputLanguage);
        System.out.println("******************************************************************************");
        converter.transcodeAllFilesInFolder(inputFolder, outputFolder, outputClassNamePrefix, outputFileNameExtension, outputPackageName, languageRenderer, templateFile);
    }
}

