/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.tools.svgtranscoder.api.java;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pushingpixels.radiance.tools.svgtranscoder.api.LanguageRenderer;

public class JavaLanguageRenderer
implements LanguageRenderer {
    @Override
    public String getStatementEnd() {
        return ";";
    }

    @Override
    public String getObjectCreation(String className) {
        return "new " + className;
    }

    @Override
    public String getObjectCreationNoParams(String className) {
        return "new " + className + "()";
    }

    @Override
    public String getObjectCast(String objectName, String classToCastTo) {
        return "((" + classToCastTo + ")" + objectName + ")";
    }

    @Override
    public String getObjectNoNull(String objectName) {
        return objectName;
    }

    @Override
    public String getNullableInvocation(String objectName, String functionName, String parameter) {
        return "(" + objectName + " != null) ? " + objectName + "." + functionName + "(" + parameter + ") : " + parameter;
    }

    @Override
    public String startPrimitiveArrayOf(String primitiveTypeName) {
        return "new " + primitiveTypeName + "[] {";
    }

    @Override
    public String startGenericArrayOf(String className) {
        return "new " + className + "[] {";
    }

    @Override
    public String endArray() {
        return "}";
    }

    @Override
    public String startVariableDefinition(String variableTypeName) {
        return variableTypeName + " ";
    }

    @Override
    public String startSetterAssignment(String propertyName) {
        return ".set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1) + "(";
    }

    @Override
    public String endSetterAssignment() {
        return ")";
    }

    @Override
    public String getGetter(String propertyName) {
        return ".get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1) + "()";
    }

    @Override
    public String startMethod(String methodName, LanguageRenderer.MethodArgument ... arguments) {
        return "private void " + methodName + "(" + Stream.of(arguments).map(e -> e.type + " " + e.name).collect(Collectors.joining(",")) + ") {";
    }

    @Override
    public String endMethod() {
        return "}";
    }

    @Override
    public String getPrimitiveTypeFor(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return "int";
        }
        if (clazz == Double.TYPE) {
            return "double";
        }
        if (clazz == Float.TYPE) {
            return "float";
        }
        if (clazz == Boolean.TYPE) {
            return "boolean";
        }
        if (clazz == Character.TYPE) {
            return "char";
        }
        throw new UnsupportedOperationException(clazz.toString());
    }
}

