/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.tools.svgtranscoder.api.kotlin;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pushingpixels.radiance.tools.svgtranscoder.api.LanguageRenderer;

public class KotlinLanguageRenderer
implements LanguageRenderer {
    @Override
    public String getStatementEnd() {
        return "";
    }

    @Override
    public String getObjectCreation(String className) {
        return className;
    }

    @Override
    public String getObjectCreationNoParams(String className) {
        return className + "()";
    }

    @Override
    public String getObjectCast(String objectName, String classToCastTo) {
        return "(" + objectName + " as " + classToCastTo + ")";
    }

    @Override
    public String getObjectNoNull(String objectName) {
        return objectName + "!!";
    }

    @Override
    public String getNullableInvocation(String objectName, String functionName, String parameter) {
        return objectName + "?." + functionName + "(" + parameter + ") ?: " + parameter;
    }

    @Override
    public String startPrimitiveArrayOf(String primitiveTypeName) {
        return primitiveTypeName + "ArrayOf(";
    }

    @Override
    public String startGenericArrayOf(String className) {
        return "arrayOf(";
    }

    @Override
    public String endArray() {
        return ")";
    }

    @Override
    public String startVariableDefinition(String variableTypeName) {
        return "val ";
    }

    @Override
    public String startSetterAssignment(String propertyName) {
        return "." + propertyName + " = ";
    }

    @Override
    public String endSetterAssignment() {
        return "";
    }

    @Override
    public String getGetter(String propertyName) {
        return "." + propertyName;
    }

    @Override
    public String startMethod(String methodName, LanguageRenderer.MethodArgument ... arguments) {
        return "private fun " + methodName + "(" + Stream.of(arguments).map(e -> e.name + " : " + e.type).collect(Collectors.joining(",")) + ") {";
    }

    @Override
    public String endMethod() {
        return "}";
    }

    @Override
    public String getPrimitiveTypeFor(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return "Int";
        }
        if (clazz == Double.TYPE) {
            return "Double";
        }
        if (clazz == Float.TYPE) {
            return "Float";
        }
        if (clazz == Boolean.TYPE) {
            return "Boolean";
        }
        if (clazz == Character.TYPE) {
            return "Char";
        }
        throw new UnsupportedOperationException(clazz.toString());
    }
}

