/*
 * Decompiled with CFR 0.152.
 */
package org.pustefixframework.agent;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import javax.management.ObjectName;
import org.pustefixframework.agent.LiveAgentMBean;
import org.pustefixframework.agent.LiveClassFileTransformer;
import org.pustefixframework.agent.LiveInfo;

public class LiveAgent
implements LiveAgentMBean {
    private static String PROP_LIVEROOT = "pustefix.liveroot";
    private static String PROP_LIVEROOT_MAXDEPTH = "pustefix.liveroot.maxdepth";
    private static int DEFAULT_LIVEROOT_MAXDEPTH = 4;
    private LiveClassFileTransformer transformer;

    public LiveAgent(LiveClassFileTransformer transformer) {
        this.transformer = transformer;
    }

    @Override
    public String getLiveLocation(String moduleName) {
        return this.transformer.getLiveLocation(moduleName);
    }

    public static void premain(String agentArguments, Instrumentation instrumentation) {
        File liveRootDir = null;
        int liveRootMaxDepth = DEFAULT_LIVEROOT_MAXDEPTH;
        String liveRoot = System.getProperty(PROP_LIVEROOT);
        if (liveRoot != null) {
            String value;
            liveRootDir = new File(liveRoot);
            try {
                liveRootDir = liveRootDir.getCanonicalFile();
            }
            catch (IOException e) {
                LiveAgent.fail("Can't read liveroot dir '" + liveRootDir.getPath() + "'.");
            }
            if (!liveRootDir.exists()) {
                LiveAgent.fail("Liveroot dir '" + liveRootDir.getPath() + "' doesn't exist.");
            }
            if ((value = System.getProperty(PROP_LIVEROOT_MAXDEPTH)) != null) {
                liveRootMaxDepth = Integer.parseInt(value);
            }
        }
        LiveInfo liveInfo = null;
        if (liveRootDir == null) {
            try {
                liveInfo = new LiveInfo();
            }
            catch (Exception x) {
                LiveAgent.fail("Error reading live information [" + x.getMessage() + "]");
            }
        } else {
            liveInfo = new LiveInfo(liveRootDir, liveRootMaxDepth);
        }
        LiveClassFileTransformer transformer = new LiveClassFileTransformer(liveInfo);
        instrumentation.addTransformer(transformer);
        LiveAgent agent = new LiveAgent(transformer);
        try {
            ObjectName name = new ObjectName("Pustefix:type=LiveAgent");
            ManagementFactory.getPlatformMBeanServer().registerMBean(agent, name);
        }
        catch (Exception x) {
            throw new RuntimeException("Can't register LiveAgent", x);
        }
    }

    public static void agentmain(String args, Instrumentation inst) throws Exception {
        LiveAgent.premain(args, inst);
    }

    private static void fail(String msg) {
        System.err.println("ERROR: " + msg);
        System.exit(1);
    }
}

