/*
 * Decompiled with CFR 0.152.
 */
package org.pustefixframework.agent;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.pustefixframework.agent.LiveInfo;
import org.pustefixframework.agent.POMInfo;

public class LiveClassFileTransformer
implements ClassFileTransformer {
    private LiveInfo liveInfo;
    private Map<String, String> locationToLive = new HashMap<String, String>();
    private Set<URL> noLiveLocations = new HashSet<URL>();

    public LiveClassFileTransformer(LiveInfo liveInfo) {
        this.liveInfo = liveInfo;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        URL location = protectionDomain.getCodeSource().getLocation();
        if (location != null && location.getProtocol().equals("file")) {
            if (location.getPath().endsWith(".jar") && location.getPath().contains("WEB-INF/lib")) {
                String liveLocation = this.locationToLive.get(location.toExternalForm());
                if (liveLocation == null && !this.noLiveLocations.contains(location)) {
                    try {
                        File file = new File(location.toURI());
                        JarFile jarFile = new JarFile(file);
                        Manifest manifest = jarFile.getManifest();
                        if (manifest != null) {
                            String fileName;
                            int endInd;
                            Attributes attrs = manifest.getMainAttributes();
                            String groupId = attrs.getValue("Implementation-Vendor-Id");
                            String version = attrs.getValue("Implementation-Version");
                            if (groupId != null && version != null && (endInd = (fileName = file.getName()).indexOf(version)) > 2) {
                                String artifactId = fileName.substring(0, endInd - 1);
                                POMInfo pomInfo = new POMInfo(groupId, artifactId, version);
                                liveLocation = this.liveInfo.getLiveLocation(pomInfo);
                                if (liveLocation != null) {
                                    this.locationToLive.put(location.toExternalForm(), liveLocation);
                                } else {
                                    this.noLiveLocations.add(location);
                                }
                            }
                        }
                    }
                    catch (Exception x) {
                        System.err.println("Error reading JAR manifest [" + x.getMessage() + "]");
                    }
                }
                if (liveLocation != null) {
                    String cpath = liveLocation + "/" + className + ".class";
                    try {
                        return this.loadClass(new File(cpath));
                    }
                    catch (IOException x) {
                        System.err.println("Can't load live class '" + cpath + "' [" + x.getMessage() + "]");
                    }
                }
            } else if (location.getPath().endsWith(".class") && location.getPath().contains("WEB-INF/classes")) {
                String path = location.getPath();
                int ind = path.indexOf("/WEB-INF/classes");
                if ((ind = (path = path.substring(0, ind)).lastIndexOf(47)) > -1 && (path = path.substring(0, ind)).endsWith("/target")) {
                    path = path + "/classes";
                    String cpath = path + "/" + className + ".class";
                    try {
                        return this.loadClass(new File(cpath));
                    }
                    catch (IOException x) {
                        System.err.println("Can't load live class '" + cpath + "' [" + x.getMessage() + "]");
                    }
                }
            }
        }
        return classfileBuffer;
    }

    public String getLiveLocation(String jarPath) {
        return this.locationToLive.get(jarPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClass(File clFile) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(clFile);
        byte[] buffer = new byte[4096];
        int no = 0;
        try {
            while ((no = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, no);
            }
        }
        finally {
            ((InputStream)in).close();
            out.close();
        }
        return out.toByteArray();
    }
}

