/*
 * Decompiled with CFR 0.152.
 */
package org.pustefixframework.agent;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.pustefixframework.agent.POMInfo;
import org.pustefixframework.agent.POMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LiveInfo {
    private Map<POMInfo, String> liveUrls = new HashMap<POMInfo, String>();

    public LiveInfo() throws Exception {
        File dir;
        File test;
        String homeDir;
        File live = null;
        String userDir = System.getProperty("user.dir");
        if (userDir != null) {
            File test2;
            File dir2 = new File(userDir);
            while (!(test2 = new File(dir2, "live.xml")).exists() && (dir2 = dir2.getParentFile()) != null) {
            }
            if (test2 != null && test2.exists()) {
                live = test2;
            }
        }
        if (live == null && (homeDir = System.getProperty("user.home")) != null && (test = new File(dir = new File(homeDir), "live.xml")).exists()) {
            live = test;
        }
        if (live != null) {
            this.read(live);
        }
    }

    public LiveInfo(File liveRootDir, int liveRootMaxDepth) {
        this.findMavenProjects(liveRootDir, 0, liveRootMaxDepth);
    }

    public String getLiveLocation(POMInfo pomInfo) {
        return this.liveUrls.get(pomInfo);
    }

    private void read(File file) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = dbf.newDocumentBuilder().parse(file);
        List<Element> jarElems = this.getChildElements(doc.getDocumentElement(), "jar");
        for (Element jarElem : jarElems) {
            Element idElem = this.getChildElement(jarElem, "id");
            if (idElem == null) continue;
            Element groupIdElem = this.getChildElement(idElem, "group");
            Element artifactIdElem = this.getChildElement(idElem, "artifact");
            Element versionElem = this.getChildElement(idElem, "version");
            if (groupIdElem == null || artifactIdElem == null || versionElem == null) continue;
            POMInfo pomInfo = new POMInfo();
            pomInfo.setGroupId(groupIdElem.getTextContent().trim());
            pomInfo.setArtifactId(artifactIdElem.getTextContent().trim());
            pomInfo.setVersion(versionElem.getTextContent().trim());
            List<Element> dirElems = this.getChildElements(jarElem, "directory");
            for (Element dirElem : dirElems) {
                String dir = dirElem.getTextContent().trim();
                int ind = dir.indexOf("/src/main/resources");
                if (ind <= -1) continue;
                dir = dir.substring(0, ind) + "/target/classes";
                this.liveUrls.put(pomInfo, dir);
            }
        }
    }

    private Element getChildElement(Element element, String name) {
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element child;
            if (nodes.item(i).getNodeType() != 1 || !(child = (Element)nodes.item(i)).getNodeName().equals(name)) continue;
            return child;
        }
        return null;
    }

    private List<Element> getChildElements(Element element, String name) {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element child;
            if (nodes.item(i).getNodeType() != 1 || !(child = (Element)nodes.item(i)).getNodeName().equals(name)) continue;
            children.add(child);
        }
        return children;
    }

    private void findMavenProjects(File dir, int level, int maxDepth) {
        File[] files;
        POMParser pomParser = new POMParser();
        for (File file : files = dir.listFiles()) {
            if (!(!file.isDirectory() || file.isHidden() || file.getName().equals("CVS") || file.getName().equals("target") || file.getName().equals("src"))) {
                if (level >= maxDepth) continue;
                this.findMavenProjects(file, level + 1, maxDepth);
                continue;
            }
            if (!file.isFile() || !file.getName().equals("pom.xml") || !file.canRead()) continue;
            POMInfo pomInfo = null;
            try {
                pomInfo = pomParser.parse(file);
            }
            catch (Exception e) {
                System.err.println("Error reading POM file '" + file.getAbsolutePath() + "' [" + e.getMessage() + "].");
            }
            if (pomInfo == null) continue;
            String targetDir = new File(file.getParentFile(), "target/classes").getAbsolutePath();
            this.liveUrls.put(pomInfo, targetDir);
        }
    }
}

