/*
 * Decompiled with CFR 0.152.
 */
package org.pustefixframework.agent;

import java.io.File;
import java.io.FileInputStream;
import org.pustefixframework.agent.POMInfo;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class POMParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POMInfo parse(File file) throws Exception {
        ParsingHandler handler = new ParsingHandler();
        try (FileInputStream fis = null;){
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            InputSource in = new InputSource();
            fis = new FileInputStream(file);
            in.setByteStream(fis);
            in.setSystemId(file.toURI().toASCIIString());
            xr.parse(in);
        }
        if (handler.getPOMInfo().isComplete()) {
            return handler.getPOMInfo();
        }
        return null;
    }

    class AbortParsingException
    extends SAXException {
        private static final long serialVersionUID = 8137076865306267682L;

        AbortParsingException() {
        }
    }

    class ParsingHandler
    extends DefaultHandler {
        private int level;
        private StringBuilder content = new StringBuilder();
        private POMInfo pomInfo = new POMInfo();

        ParsingHandler() {
        }

        public POMInfo getPOMInfo() {
            return this.pomInfo;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            ++this.level;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.level == 2) {
                if (this.content == null) {
                    this.content = new StringBuilder();
                }
                this.content.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.level == 2) {
                String str = this.content.toString().trim();
                if (localName.equals("groupId")) {
                    this.pomInfo.setGroupId(str);
                    if (this.pomInfo.isComplete()) {
                        throw new AbortParsingException();
                    }
                } else if (localName.equals("artifactId")) {
                    this.pomInfo.setArtifactId(str);
                    if (this.pomInfo.isComplete()) {
                        throw new AbortParsingException();
                    }
                } else if (localName.equals("version")) {
                    this.pomInfo.setVersion(str);
                    if (this.pomInfo.isComplete()) {
                        throw new AbortParsingException();
                    }
                }
                this.content = null;
            }
            --this.level;
        }
    }
}

