/*
 * Decompiled with CFR 0.152.
 */
package org.pustefixframework.example.numberguess.handler;

import de.schlund.pfixcore.generator.IHandler;
import de.schlund.pfixcore.generator.IWrapper;
import de.schlund.pfixcore.workflow.Context;
import java.util.Random;
import org.pustefixframework.example.numberguess.StatusCodes;
import org.pustefixframework.example.numberguess.context.GuessContext;
import org.pustefixframework.example.numberguess.context.StatisticsContext;
import org.pustefixframework.example.numberguess.context.UserContext;
import org.pustefixframework.example.numberguess.wrapper.GuessDataWrapper;
import org.springframework.beans.factory.annotation.Autowired;

public class GuessDataHandler
implements IHandler {
    private StatisticsContext statisticsContext;
    private GuessContext guessContext;
    private UserContext userDataContext;
    private static Random random = new Random();

    public void handleSubmittedData(Context context, IWrapper wrapper) throws Exception {
        GuessDataWrapper guessData = (GuessDataWrapper)wrapper;
        int number = guessData.getNumber();
        int randomNumber = random.nextInt(10);
        this.guessContext.setGuess(Integer.valueOf(number));
        this.guessContext.setRandom(Integer.valueOf(randomNumber));
        this.statisticsContext.incTries();
        if (number == randomNumber) {
            context.addPageMessage(StatusCodes.SUCCESS, null, null);
            this.statisticsContext.incSuccess();
        } else {
            guessData.addSCodeNumber(StatusCodes.FAILURE, new String[]{String.valueOf(randomNumber)}, null);
        }
    }

    public boolean isActive(Context context) throws Exception {
        return true;
    }

    public boolean needsData(Context context) throws Exception {
        return this.guessContext.getGuess() == null;
    }

    public boolean prerequisitesMet(Context context) throws Exception {
        return this.userDataContext.getName() != null;
    }

    public void retrieveCurrentStatus(Context context, IWrapper wrapper) throws Exception {
        GuessDataWrapper guessData = (GuessDataWrapper)wrapper;
        guessData.setStringValNumber("0");
    }

    @Autowired
    public void setGuessContext(GuessContext guessContext) {
        this.guessContext = guessContext;
    }

    @Autowired
    public void setStatisticsContext(StatisticsContext statisticsContext) {
        this.statisticsContext = statisticsContext;
    }

    @Autowired
    public void setUserDataContext(UserContext userDataContext) {
        this.userDataContext = userDataContext;
    }
}

