/*
 * This file is part of Pustefix.
 *
 * Pustefix is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Pustefix is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Pustefix; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
    
package org.pustefixframework.example.numberguess.wrapper;
    
import de.schlund.pfixcore.generator.*;

import de.schlund.pfixcore.generator.annotation.*;

/**
 * THIS CLASS IS AUTOGENERATED! DO NOT EDIT IN ANY WAY!
 */
@UseHandlerClass(org.pustefixframework.example.numberguess.handler.GuessDataHandler.class)
public class GuessDataWrapper extends IWrapperImpl {

    @Override
    protected synchronized void registerParams() {
        
        IWrapperParam          pinfo;
        
        IWrapperParamCaster    caster;
         
        IWrapperParamPostCheck post;
        
        // number
        if(!params.containsKey("number")) {
        pinfo  = new IWrapperParam("number", false, false, null, "java.lang.Integer", true);
          
        params.put("number", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToInteger();
        pinfo.setParamCaster(caster);
    
        post = new de.schlund.pfixcore.generator.postchecks.IntegerRange();
        pinfo.addPostChecker(post);
    
        ((de.schlund.pfixcore.generator.postchecks.IntegerRange) post).setRange("0:9");
    
        }  
        
      
        super.registerParams();
    }
    
    // number
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToInteger.class
    )
    @PostCheck(
        type=de.schlund.pfixcore.generator.postchecks.IntegerRange.class,
        properties={
            @Property(name="range",value="0:9")
        }
    )
    public java.lang.Integer getNumber() {
        return (java.lang.Integer) gimmeParamForKey("number").getValue();
    }
    
    public void setStringValNumber(String v) {
        gimmeParamForKey("number").
          setStringValue(new String[] {v});
    }

    public void setNumber(java.lang.Integer v) {
        IWrapperParam iwrpParam = gimmeParamForKey("number");
        setStringValue(new java.lang.Integer[] {v}, iwrpParam);
    }

    public void addSCodeNumber(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("number"), scode, null, null);
    }

    public void addSCodeNumber(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("number"), scode, args, level);
    }

    /**
      * @deprecated use addScodeNumber(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsNumber(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("number"), scode, args, null);
    }
        
}
  