/*
 * This file is part of Pustefix.
 *
 * Pustefix is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Pustefix is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Pustefix; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.pustefixframework.sample.basic;

import de.schlund.util.statuscodes.StatusCode;
import de.schlund.util.statuscodes.StatusCodeException;
import de.schlund.util.statuscodes.StatusCodeHelper;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;

public class StatusCodes {

    public static StatusCode getStatusCodeByName(String name) throws StatusCodeException {
        return getStatusCodeByName(name, false);
    }

    public static StatusCode getStatusCodeByName(String name, boolean optional) throws StatusCodeException {
        String     fieldname = StatusCode.convertToFieldName(name);
        StatusCode scode     = null;
        try {
            Field field = StatusCodes.class.getField(fieldname);
            scode = (StatusCode) field.get(null);
        } catch (NoSuchFieldException e) {
            //
        } catch (SecurityException e) {
            //
        } catch (IllegalAccessException e) {
            //
        }
        if (scode == null && optional == false) {
            throw new StatusCodeException("StatusCode " + name + " is not defined.");
        }
        return scode;
    }

    public static final URI[] __URI;

    static {
        try {
            __URI = StatusCodeHelper.update(new URI[] {
                new URI("docroot:/dyntxt/statusmessages.xml")
            });
        } catch (URISyntaxException e) {
            throw new RuntimeException("Illegal URI", e);
        }
    };

    public static final StatusCode INVALID_NAME = new StatusCode("INVALID_NAME", __URI[0]);
}
