/*
 * This file is part of Pustefix.
 *
 * Pustefix is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Pustefix is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Pustefix; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package de.schlund.pfixcore.example;

import de.schlund.util.statuscodes.StatusCode;
import de.schlund.util.statuscodes.StatusCodeException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;

public class StatusCodeLib {

    public static StatusCode getStatusCodeByName(String name) throws StatusCodeException {
        return getStatusCodeByName(name, false);
    }

    public static StatusCode getStatusCodeByName(String name, boolean optional) throws StatusCodeException {
        String     fieldname = StatusCode.convertToFieldName(name);
        StatusCode scode     = null;
        try {
            Field field = StatusCodeLib.class.getField(fieldname);
            scode = (StatusCode) field.get(null);
        } catch (NoSuchFieldException e) {
            //
        } catch (SecurityException e) {
            //
        } catch (IllegalAccessException e) {
            //
        }
        if (scode == null && optional == false) {
            throw new StatusCodeException("StatusCode " + name + " is not defined.");
        }
        return scode;
    }

    public static final URI[] __URI;

    static {
        try {
            __URI = new URI[] {
                new URI("docroot:/dyntxt/statusmessages.xml")
            };
        } catch (URISyntaxException e) {
            throw new RuntimeException("Illegal URI", e);
        }
    };

    public static final StatusCode COUNTER_INFO_GREATER_3 = new StatusCode("counter.INFO_GREATER_3", __URI[0]);
    public static final StatusCode COUNTER_WARN_GREATER_5 = new StatusCode("counter.WARN_GREATER_5", __URI[0]);
    public static final StatusCode COUNTER_WARN_GREATER_9 = new StatusCode("counter.WARN_GREATER_9", __URI[0]);
    public static final StatusCode HOME_AGE_MISSING = new StatusCode("home.AGE_MISSING", __URI[0]);
    public static final StatusCode HOME_NO_AGE = new StatusCode("home.NO_AGE", __URI[0]);
    public static final StatusCode TROUSER_FEATURECOLOR_OUTOF_STOCK = new StatusCode("trouser.FEATURECOLOR_OUTOF_STOCK", __URI[0]);
    public static final StatusCode TSHIRT_SIZECOLOR_OUTOF_STOCK = new StatusCode("tshirt.SIZECOLOR_OUTOF_STOCK", __URI[0]);
    public static final StatusCode TSHIRT_SCRIPTING_SUCCESS = new StatusCode("tshirt.SCRIPTING_SUCCESS", __URI[0]);
    public static final StatusCode CHECKS_DATE_ERR = new StatusCode("checks.DATE_ERR", __URI[0]);
    public static final StatusCode CHECKS_INT_ERR = new StatusCode("checks.INT_ERR", __URI[0]);
    public static final StatusCode CHECKS_BOOL_ERR = new StatusCode("checks.BOOL_ERR", __URI[0]);
    public static final StatusCode CHECKS_BYTE_ERR = new StatusCode("checks.BYTE_ERR", __URI[0]);
    public static final StatusCode CHECKS_LONG_ERR = new StatusCode("checks.LONG_ERR", __URI[0]);
    public static final StatusCode CHECKS_FLOAT_ERR = new StatusCode("checks.FLOAT_ERR", __URI[0]);
    public static final StatusCode CHECKS_DOUBLE_ERR = new StatusCode("checks.DOUBLE_ERR", __URI[0]);
    public static final StatusCode CHECKS_PERL5_ERR = new StatusCode("checks.PERL5_ERR", __URI[0]);
    public static final StatusCode CHECKS_FLOAT_TOO_SMALL = new StatusCode("checks.FLOAT_TOO_SMALL", __URI[0]);
    public static final StatusCode CHECKS_FLOAT_TOO_BIG = new StatusCode("checks.FLOAT_TOO_BIG", __URI[0]);
    public static final StatusCode CHECKS_INT_TOO_SMALL = new StatusCode("checks.INT_TOO_SMALL", __URI[0]);
    public static final StatusCode CHECKS_INT_TOO_BIG = new StatusCode("checks.INT_TOO_BIG", __URI[0]);
    public static final StatusCode CHECKS_STRING_TOO_SHORT = new StatusCode("checks.STRING_TOO_SHORT", __URI[0]);
    public static final StatusCode CHECKS_STRING_TOO_LONG = new StatusCode("checks.STRING_TOO_LONG", __URI[0]);
    public static final StatusCode CHECKS_REGEXP_NO_MATCH = new StatusCode("checks.REGEXP_NO_MATCH", __URI[0]);
    public static final StatusCode CHECKS_FILE_ERR = new StatusCode("checks.FILE_ERR", __URI[0]);
    public static final StatusCode CHECKS_UPLOAD_FILE_ERR = new StatusCode("checks.UPLOAD_FILE_ERR", __URI[0]);
}
