/*
 * This file is part of Pustefix.
 *
 * Pustefix is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Pustefix is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Pustefix; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
    
package de.schlund.pfixcore.example.test;
    
import de.schlund.pfixcore.generator.*;

import de.schlund.pfixcore.generator.annotation.*;

/**
 * THIS CLASS IS AUTOGENERATED! DO NOT EDIT IN ANY WAY!
 */
@UseHandlerClass(de.schlund.pfixcore.example.test.BeanDummyHandler.class)
public class BeanWrapper extends IWrapperImpl {

    @Override
    protected synchronized void registerParams() {
        
        IWrapperParam          pinfo;
        
        IWrapperParamCaster    caster;
        
        // FloatValues
        if(!params.containsKey("FloatValues")) {
        pinfo  = new IWrapperParam("FloatValues", true, false, null, "java.lang.Float", true);
          
        params.put("FloatValues", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToFloat();
        pinfo.setParamCaster(caster);
    
        }  
        
      
        // Text
        if(!params.containsKey("Text")) {
        pinfo  = new IWrapperParam("Text", false, false, null, "java.lang.String", true);
          
        params.put("Text", pinfo);
          
        }  
        
      
        // Values
        if(!params.containsKey("Values")) {
        pinfo  = new IWrapperParam("Values", true, false, null, "java.lang.Integer", true);
          
        params.put("Values", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToInteger();
        pinfo.setParamCaster(caster);
    
        }  
        
      
        // Data
        if(!params.containsKey("Data")) {
        pinfo  = new IWrapperParam("Data", false, false, null, "de.schlund.pfixcore.example.test.Data", true);
          
        params.put("Data", pinfo);
          
        caster = new de.schlund.pfixcore.example.test.DataCaster();
        pinfo.setParamCaster(caster);
    
        }  
        
      
        // DataList
        if(!params.containsKey("DataList")) {
        pinfo  = new IWrapperParam("DataList", true, false, null, "de.schlund.pfixcore.example.test.Data", true);
          
        params.put("DataList", pinfo);
          
        caster = new de.schlund.pfixcore.example.test.DataCaster();
        pinfo.setParamCaster(caster);
    
        }  
        
      
        super.registerParams();
    }
    
    // FloatValues
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToFloat.class
    )
    public java.lang.Float[] getFloatValues() {
        return (java.lang.Float[]) gimmeParamForKey("FloatValues").getValueArr();
    }
    
    public void setStringValFloatValues(String[] v) {
        gimmeParamForKey("FloatValues").
          setStringValue(v);
    }

    public void setFloatValues(java.lang.Float[] v) {
        IWrapperParam iwrpParam = gimmeParamForKey("FloatValues");
        setStringValue(v, iwrpParam);
    }

    public void addSCodeFloatValues(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("FloatValues"), scode, null, null);
    }

    public void addSCodeFloatValues(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("FloatValues"), scode, args, level);
    }

    /**
      * @deprecated use addScodeFloatValues(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsFloatValues(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("FloatValues"), scode, args, null);
    }
        
    // Text
    public java.lang.String getText() {
        return (java.lang.String) gimmeParamForKey("Text").getValue();
    }
    
    public void setStringValText(String v) {
        gimmeParamForKey("Text").
          setStringValue(new String[] {v});
    }

    public void setText(java.lang.String v) {
        IWrapperParam iwrpParam = gimmeParamForKey("Text");
        setStringValue(new java.lang.String[] {v}, iwrpParam);
    }

    public void addSCodeText(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("Text"), scode, null, null);
    }

    public void addSCodeText(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("Text"), scode, args, level);
    }

    /**
      * @deprecated use addScodeText(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsText(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("Text"), scode, args, null);
    }
        
    // Values
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToInteger.class
    )
    public java.lang.Integer[] getValues() {
        return (java.lang.Integer[]) gimmeParamForKey("Values").getValueArr();
    }
    
    public void setStringValValues(String[] v) {
        gimmeParamForKey("Values").
          setStringValue(v);
    }

    public void setValues(java.lang.Integer[] v) {
        IWrapperParam iwrpParam = gimmeParamForKey("Values");
        setStringValue(v, iwrpParam);
    }

    public void addSCodeValues(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("Values"), scode, null, null);
    }

    public void addSCodeValues(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("Values"), scode, args, level);
    }

    /**
      * @deprecated use addScodeValues(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsValues(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("Values"), scode, args, null);
    }
        
    // Data
    @Caster(
        type=de.schlund.pfixcore.example.test.DataCaster.class
    )
    public de.schlund.pfixcore.example.test.Data getData() {
        return (de.schlund.pfixcore.example.test.Data) gimmeParamForKey("Data").getValue();
    }
    
    public void setStringValData(String v) {
        gimmeParamForKey("Data").
          setStringValue(new String[] {v});
    }

    public void setData(de.schlund.pfixcore.example.test.Data v) {
        IWrapperParam iwrpParam = gimmeParamForKey("Data");
        setStringValue(new de.schlund.pfixcore.example.test.Data[] {v}, iwrpParam);
    }

    public void addSCodeData(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("Data"), scode, null, null);
    }

    public void addSCodeData(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("Data"), scode, args, level);
    }

    /**
      * @deprecated use addScodeData(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsData(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("Data"), scode, args, null);
    }
        
    // DataList
    @Caster(
        type=de.schlund.pfixcore.example.test.DataCaster.class
    )
    public de.schlund.pfixcore.example.test.Data[] getDataList() {
        return (de.schlund.pfixcore.example.test.Data[]) gimmeParamForKey("DataList").getValueArr();
    }
    
    public void setStringValDataList(String[] v) {
        gimmeParamForKey("DataList").
          setStringValue(v);
    }

    public void setDataList(de.schlund.pfixcore.example.test.Data[] v) {
        IWrapperParam iwrpParam = gimmeParamForKey("DataList");
        setStringValue(v, iwrpParam);
    }

    public void addSCodeDataList(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("DataList"), scode, null, null);
    }

    public void addSCodeDataList(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("DataList"), scode, args, level);
    }

    /**
      * @deprecated use addScodeDataList(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsDataList(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("DataList"), scode, args, null);
    }
        
}
  