/*
 * This file is part of Pustefix.
 *
 * Pustefix is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Pustefix is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Pustefix; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
    
package de.schlund.pfixcore.example.iwrapper;
    
import de.schlund.pfixcore.generator.*;

import de.schlund.pfixcore.generator.annotation.*;

/**
 * THIS CLASS IS AUTOGENERATED! DO NOT EDIT IN ANY WAY!
 */
@UseHandlerClass(de.schlund.pfixcore.example.AdultInfoHandler.class)
public class AdultInfo extends IWrapperImpl {

    @Override
    protected synchronized void registerParams() {
        
        IWrapperParam          pinfo;
        
        IWrapperParamCaster    caster;
        
        // Adult
        if(!params.containsKey("Adult")) {
        pinfo  = new IWrapperParam("Adult", false, false, null, "java.lang.Boolean", true);
          
        pinfo.setCustomSCode("de.schlund.pfixcore.example.StatusCodeLib#home.AGE_MISSING");
          
        params.put("Adult", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToBoolean();
        pinfo.setParamCaster(caster);
    
        ((de.schlund.pfixcore.generator.casters.ToBoolean) caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#home.NO_AGE");
    
        }  
        
      
        // Date
        if(!params.containsKey("Date")) {
        pinfo  = new IWrapperParam("Date", false, true, null, "java.util.Date", true);
          
        params.put("Date", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToDate();
        pinfo.setParamCaster(caster);
    
        ((de.schlund.pfixcore.generator.casters.ToDate) caster).setParamFormat("yy/MM/dd");
    
        }  
        
      
        super.registerParams();
    }
    
    // Adult
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToBoolean.class,
        properties={
            @Property(name="scodeCastError",value="de.schlund.pfixcore.example.StatusCodeLib#home.NO_AGE")
        }
    )
    public java.lang.Boolean getAdult() {
        return (java.lang.Boolean) gimmeParamForKey("Adult").getValue();
    }
    
    public void setStringValAdult(String v) {
        gimmeParamForKey("Adult").
          setStringValue(new String[] {v});
    }

    public void setAdult(java.lang.Boolean v) {
        IWrapperParam iwrpParam = gimmeParamForKey("Adult");
        setStringValue(new java.lang.Boolean[] {v}, iwrpParam);
    }

    public void addSCodeAdult(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("Adult"), scode, null, null);
    }

    public void addSCodeAdult(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("Adult"), scode, args, level);
    }

    /**
      * @deprecated use addScodeAdult(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsAdult(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("Adult"), scode, args, null);
    }
        
    // Date
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToDate.class,
        properties={
            @Property(name="paramFormat",value="yy/MM/dd")
        }
    )
    public java.util.Date getDate() {
        return (java.util.Date) gimmeParamForKey("Date").getValue();
    }
    
    public void setStringValDate(String v) {
        gimmeParamForKey("Date").
          setStringValue(new String[] {v});
    }

    public void setDate(java.util.Date v) {
        IWrapperParam iwrpParam = gimmeParamForKey("Date");
        setStringValue(new java.util.Date[] {v}, iwrpParam);
    }

    public void addSCodeDate(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("Date"), scode, null, null);
    }

    public void addSCodeDate(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("Date"), scode, args, level);
    }

    /**
      * @deprecated use addScodeDate(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsDate(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("Date"), scode, args, null);
    }
        
}
  