/*
 * This file is part of Pustefix.
 *
 * Pustefix is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Pustefix is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Pustefix; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
    
package de.schlund.pfixcore.example.iwrapper;
    
import de.schlund.pfixcore.generator.*;

import de.schlund.pfixcore.generator.annotation.*;

/**
 * THIS CLASS IS AUTOGENERATED! DO NOT EDIT IN ANY WAY!
 */
@UseHandlerClass(de.schlund.pfixcore.example.IndexedTestHandler.class)
public class IndexedTest extends IWrapperImpl {

    @Override
    protected synchronized void registerParams() {
        
        IWrapperIndexedParam   pindx;
         
        IWrapperParamPreCheck  pre;
        
        // Value
        if(!idxprms.containsKey("Value")) {
        pindx  = new IWrapperIndexedParam("Value", false, "java.lang.String", true);
        idxprms.put("Value", pindx);
          
        pre = new de.schlund.pfixcore.generator.prechecks.RegexpCheck();
        pindx.addPreChecker(pre);
    
        ((de.schlund.pfixcore.generator.prechecks.RegexpCheck) pre).setRegexp("/^[a-zA-Z]*$/");
    
        }
        
      
        super.registerParams();
    }
    
    // Value
    @PreCheck(
        type=de.schlund.pfixcore.generator.prechecks.RegexpCheck.class,
        properties={
            @Property(name="regexp",value="/^[a-zA-Z]*$/")
        }
    )
    public java.lang.String getValue(String index) {
        return (java.lang.String) gimmeIndexedParamForKey("Value").getParamForIndex(index).getValue();
    }

    public java.lang.String[] getKeysValue() {
        return gimmeIndexedParamForKey("Value").getKeys();
    }
          
    public void setStringValValue(String v, String index) {
        gimmeIndexedParamForKey("Value").getParamForIndex(index).
          setStringValue(new String[] {v});
    }

    public void setValue(java.lang.String v, String index) {
        gimmeIndexedParamForKey("Value").getParamForIndex(index).
          setStringValue(new java.lang.String[] {v});
    }

    public void addSCodeValue(de.schlund.util.statuscodes.StatusCode scode, String index) {
        gimmeIndexedParamForKey("Value").addSCode(scode, null, null, index);
    }

    public void addSCodeValue(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level, String index) {
        gimmeIndexedParamForKey("Value").addSCode(scode, args, level, index);
    }
    
    /**
      * @deprecated use addScodeValue(scode, args, null, index)
      */
    @Deprecated
    public void addSCodeWithArgsValue(de.schlund.util.statuscodes.StatusCode scode, String[] args, String index) {
        gimmeIndexedParamForKey("Value").addSCode(scode, args, null, index);
    }
        
}
  