/*
 * This file is part of Pustefix.
 *
 * Pustefix is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Pustefix is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Pustefix; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
    
package de.schlund.pfixcore.example.iwrapper;
    
import de.schlund.pfixcore.generator.*;

import de.schlund.pfixcore.generator.annotation.*;

/**
 * THIS CLASS IS AUTOGENERATED! DO NOT EDIT IN ANY WAY!
 */
@UseHandlerClass(de.schlund.pfixcore.example.TShirtHandler.class)
public class TShirt extends IWrapperImpl {

    @Override
    protected synchronized void registerParams() {
        
        IWrapperParam          pinfo;
        
        IWrapperParamCaster    caster;
         
        IWrapperParamPreCheck  pre;
         
        IWrapperParamPostCheck post;
        
        // Size
        if(!params.containsKey("Size")) {
        pinfo  = new IWrapperParam("Size", false, false, null, "java.lang.String", true);
          
        params.put("Size", pinfo);
          
        pre = new de.schlund.pfixcore.generator.prechecks.RegexpCheck();
        pinfo.addPreChecker(pre);
    
        ((de.schlund.pfixcore.generator.prechecks.RegexpCheck) pre).setRegexp("(S|M|L|XL|XXL)");
    
        }  
        
      
        // Color
        if(!params.containsKey("Color")) {
        pinfo  = new IWrapperParam("Color", false, false, null, "java.lang.Integer", true);
          
        params.put("Color", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToInteger();
        pinfo.setParamCaster(caster);
    
        }  
        
      
        // Feature
        if(!params.containsKey("Feature")) {
        pinfo  = new IWrapperParam("Feature", true, true, null, "java.lang.Integer", true);
          
        params.put("Feature", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToInteger();
        pinfo.setParamCaster(caster);
    
        post = new de.schlund.pfixcore.generator.postchecks.IntegerRange();
        pinfo.addPostChecker(post);
    
        ((de.schlund.pfixcore.generator.postchecks.IntegerRange) post).setRange("0:2");
    
        }  
        
      
        super.registerParams();
    }
    
    // Size
    @PreCheck(
        type=de.schlund.pfixcore.generator.prechecks.RegexpCheck.class,
        properties={
            @Property(name="regexp",value="(S|M|L|XL|XXL)")
        }
    )
    public java.lang.String getSize() {
        return (java.lang.String) gimmeParamForKey("Size").getValue();
    }
    
    public void setStringValSize(String v) {
        gimmeParamForKey("Size").
          setStringValue(new String[] {v});
    }

    public void setSize(java.lang.String v) {
        IWrapperParam iwrpParam = gimmeParamForKey("Size");
        setStringValue(new java.lang.String[] {v}, iwrpParam);
    }

    public void addSCodeSize(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("Size"), scode, null, null);
    }

    public void addSCodeSize(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("Size"), scode, args, level);
    }

    /**
      * @deprecated use addScodeSize(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsSize(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("Size"), scode, args, null);
    }
        
    // Color
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToInteger.class
    )
    public java.lang.Integer getColor() {
        return (java.lang.Integer) gimmeParamForKey("Color").getValue();
    }
    
    public void setStringValColor(String v) {
        gimmeParamForKey("Color").
          setStringValue(new String[] {v});
    }

    public void setColor(java.lang.Integer v) {
        IWrapperParam iwrpParam = gimmeParamForKey("Color");
        setStringValue(new java.lang.Integer[] {v}, iwrpParam);
    }

    public void addSCodeColor(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("Color"), scode, null, null);
    }

    public void addSCodeColor(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("Color"), scode, args, level);
    }

    /**
      * @deprecated use addScodeColor(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsColor(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("Color"), scode, args, null);
    }
        
    // Feature
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToInteger.class
    )
    @PostCheck(
        type=de.schlund.pfixcore.generator.postchecks.IntegerRange.class,
        properties={
            @Property(name="range",value="0:2")
        }
    )
    public java.lang.Integer[] getFeature() {
        return (java.lang.Integer[]) gimmeParamForKey("Feature").getValueArr();
    }
    
    public void setStringValFeature(String[] v) {
        gimmeParamForKey("Feature").
          setStringValue(v);
    }

    public void setFeature(java.lang.Integer[] v) {
        IWrapperParam iwrpParam = gimmeParamForKey("Feature");
        setStringValue(v, iwrpParam);
    }

    public void addSCodeFeature(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("Feature"), scode, null, null);
    }

    public void addSCodeFeature(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("Feature"), scode, args, level);
    }

    /**
      * @deprecated use addScodeFeature(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsFeature(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("Feature"), scode, args, null);
    }
        
}
  