/*
 * This file is part of Pustefix.
 *
 * Pustefix is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Pustefix is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Pustefix; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
    
package de.schlund.pfixcore.example.iwrapper;
    
import de.schlund.pfixcore.generator.*;

import de.schlund.pfixcore.generator.annotation.*;

/**
 * THIS CLASS IS AUTOGENERATED! DO NOT EDIT IN ANY WAY!
 */
@UseHandlerClass(de.schlund.pfixcore.example.EncodingTestUploadHandler.class)
public class EncodingTestUpload extends IWrapperImpl {

    @Override
    protected synchronized void registerParams() {
        
        IWrapperParam          pinfo;
        
        IWrapperParamCaster    caster;
        
        // Text
        if(!params.containsKey("Text")) {
        pinfo  = new IWrapperParam("Text", false, true, null, "java.lang.String", true);
          
        params.put("Text", pinfo);
          
        }  
        
      
        // File
        if(!params.containsKey("File")) {
        pinfo  = new IWrapperParam("File", false, true, null, "java.io.File", true);
          
        params.put("File", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToFile();
        pinfo.setParamCaster(caster);
    
        }  
        
      
        super.registerParams();
    }
    
    // Text
    public java.lang.String getText() {
        return (java.lang.String) gimmeParamForKey("Text").getValue();
    }
    
    public void setStringValText(String v) {
        gimmeParamForKey("Text").
          setStringValue(new String[] {v});
    }

    public void setText(java.lang.String v) {
        IWrapperParam iwrpParam = gimmeParamForKey("Text");
        setStringValue(new java.lang.String[] {v}, iwrpParam);
    }

    public void addSCodeText(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("Text"), scode, null, null);
    }

    public void addSCodeText(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("Text"), scode, args, level);
    }

    /**
      * @deprecated use addScodeText(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsText(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("Text"), scode, args, null);
    }
        
    // File
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToFile.class
    )
    public java.io.File getFile() {
        return (java.io.File) gimmeParamForKey("File").getValue();
    }
    
    public void setStringValFile(String v) {
        gimmeParamForKey("File").
          setStringValue(new String[] {v});
    }

    public void setFile(java.io.File v) {
        IWrapperParam iwrpParam = gimmeParamForKey("File");
        setStringValue(new java.io.File[] {v}, iwrpParam);
    }

    public void addSCodeFile(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("File"), scode, null, null);
    }

    public void addSCodeFile(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("File"), scode, args, level);
    }

    /**
      * @deprecated use addScodeFile(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsFile(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("File"), scode, args, null);
    }
        
}
  