/*
 * This file is part of Pustefix.
 *
 * Pustefix is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Pustefix is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Pustefix; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
    
package de.schlund.pfixcore.example.iwrapper;
    
import de.schlund.pfixcore.generator.*;

import de.schlund.pfixcore.generator.annotation.*;

/**
 * THIS CLASS IS AUTOGENERATED! DO NOT EDIT IN ANY WAY!
 */
@UseHandlerClass(de.schlund.pfixcore.example.SearchHandler.class)
public class Search extends IWrapperImpl {

    @Override
    protected synchronized void registerParams() {
        
        IWrapperParam          pinfo;
         
        IWrapperParamPostCheck post;
        
        // term
        if(!params.containsKey("term")) {
        pinfo  = new IWrapperParam("term", false, true, null, "java.lang.String", true);
          
        params.put("term", pinfo);
          
        post = new de.schlund.pfixcore.generator.postchecks.StringLength();
        pinfo.addPostChecker(post);
    
        ((de.schlund.pfixcore.generator.postchecks.StringLength) post).setMinLength("3");
    
        ((de.schlund.pfixcore.generator.postchecks.StringLength) post).setMaxLength("30");
    
        }  
        
      
        super.registerParams();
    }
    
    // term
    @PostCheck(
        type=de.schlund.pfixcore.generator.postchecks.StringLength.class,
        properties={
            @Property(name="minLength",value="3"),
            @Property(name="maxLength",value="30")
        }
    )
    public java.lang.String getTerm() {
        return (java.lang.String) gimmeParamForKey("term").getValue();
    }
    
    public void setStringValTerm(String v) {
        gimmeParamForKey("term").
          setStringValue(new String[] {v});
    }

    public void setTerm(java.lang.String v) {
        IWrapperParam iwrpParam = gimmeParamForKey("term");
        setStringValue(new java.lang.String[] {v}, iwrpParam);
    }

    public void addSCodeTerm(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("term"), scode, null, null);
    }

    public void addSCodeTerm(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("term"), scode, args, level);
    }

    /**
      * @deprecated use addScodeTerm(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsTerm(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("term"), scode, args, null);
    }
        
}
  