/*
 * This file is part of Pustefix.
 *
 * Pustefix is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Pustefix is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Pustefix; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
    
package de.schlund.pfixcore.example.iwrapper;
    
import de.schlund.pfixcore.generator.*;

import de.schlund.pfixcore.generator.annotation.*;

/**
 * THIS CLASS IS AUTOGENERATED! DO NOT EDIT IN ANY WAY!
 */
@UseHandlerClass(de.schlund.pfixcore.example.TestChecksHandler.class)
public class TestChecks extends IWrapperImpl {

    @Override
    protected synchronized void registerParams() {
        
        IWrapperParam          pinfo;
        
        IWrapperParamCaster    caster;
         
        IWrapperParamPreCheck  pre;
         
        IWrapperParamPostCheck post;
        
        // Date
        if(!params.containsKey("Date")) {
        pinfo  = new IWrapperParam("Date", false, true, null, "java.util.Date", true);
          
        params.put("Date", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToDate();
        pinfo.setParamCaster(caster);
    
        ((de.schlund.pfixcore.generator.casters.ToDate) caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.DATE_ERR");
    
        ((de.schlund.pfixcore.generator.casters.ToDate) caster).setFormat("yy/MM/dd");
    
        ((de.schlund.pfixcore.generator.casters.ToDate) caster).setParamFormat("yy/MM/dd");
    
        }  
        
      
        // Integer
        if(!params.containsKey("Integer")) {
        pinfo  = new IWrapperParam("Integer", false, true, null, "java.lang.Integer", true);
          
        params.put("Integer", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToInteger();
        pinfo.setParamCaster(caster);
    
        ((de.schlund.pfixcore.generator.casters.ToInteger) caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.INT_ERR");
    
        }  
        
      
        // Boolean
        if(!params.containsKey("Boolean")) {
        pinfo  = new IWrapperParam("Boolean", false, true, null, "java.lang.Boolean", true);
          
        params.put("Boolean", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToBoolean();
        pinfo.setParamCaster(caster);
    
        ((de.schlund.pfixcore.generator.casters.ToBoolean) caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.BOOL_ERR");
    
        }  
        
      
        // Byte
        if(!params.containsKey("Byte")) {
        pinfo  = new IWrapperParam("Byte", false, true, null, "java.lang.Byte", true);
          
        params.put("Byte", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToByte();
        pinfo.setParamCaster(caster);
    
        ((de.schlund.pfixcore.generator.casters.ToByte) caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.BYTE_ERR");
    
        }  
        
      
        // Long
        if(!params.containsKey("Long")) {
        pinfo  = new IWrapperParam("Long", false, true, null, "java.lang.Long", true);
          
        params.put("Long", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToLong();
        pinfo.setParamCaster(caster);
    
        ((de.schlund.pfixcore.generator.casters.ToLong) caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.LONG_ERR");
    
        }  
        
      
        // Float
        if(!params.containsKey("Float")) {
        pinfo  = new IWrapperParam("Float", false, true, null, "java.lang.Float", true);
          
        params.put("Float", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToFloat();
        pinfo.setParamCaster(caster);
    
        ((de.schlund.pfixcore.generator.casters.ToFloat) caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.FLOAT_ERR");
    
        }  
        
      
        // Double
        if(!params.containsKey("Double")) {
        pinfo  = new IWrapperParam("Double", false, true, null, "java.lang.Double", true);
          
        params.put("Double", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToDouble();
        pinfo.setParamCaster(caster);
    
        ((de.schlund.pfixcore.generator.casters.ToDouble) caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.DOUBLE_ERR");
    
        }  
        
      
        // FloatRange
        if(!params.containsKey("FloatRange")) {
        pinfo  = new IWrapperParam("FloatRange", false, true, null, "java.lang.Float", true);
          
        params.put("FloatRange", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToFloat();
        pinfo.setParamCaster(caster);
    
        ((de.schlund.pfixcore.generator.casters.ToFloat) caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.FLOAT_ERR");
    
        post = new de.schlund.pfixcore.generator.postchecks.FloatRange();
        pinfo.addPostChecker(post);
    
        ((de.schlund.pfixcore.generator.postchecks.FloatRange) post).setRange("1.1:2.5");
    
        ((de.schlund.pfixcore.generator.postchecks.FloatRange) post).setScodeTooSmall("de.schlund.pfixcore.example.StatusCodeLib#checks.FLOAT_TOO_SMALL");
    
        ((de.schlund.pfixcore.generator.postchecks.FloatRange) post).setScodeTooBig("de.schlund.pfixcore.example.StatusCodeLib#checks.FLOAT_TOO_BIG");
    
        }  
        
      
        // IntegerRange
        if(!params.containsKey("IntegerRange")) {
        pinfo  = new IWrapperParam("IntegerRange", false, true, null, "java.lang.Integer", true);
          
        params.put("IntegerRange", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToInteger();
        pinfo.setParamCaster(caster);
    
        ((de.schlund.pfixcore.generator.casters.ToInteger) caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.INT_ERR");
    
        post = new de.schlund.pfixcore.generator.postchecks.IntegerRange();
        pinfo.addPostChecker(post);
    
        ((de.schlund.pfixcore.generator.postchecks.IntegerRange) post).setRange("10:20");
    
        ((de.schlund.pfixcore.generator.postchecks.IntegerRange) post).setScodeTooSmall("de.schlund.pfixcore.example.StatusCodeLib#checks.INT_TOO_SMALL");
    
        ((de.schlund.pfixcore.generator.postchecks.IntegerRange) post).setScodeTooBig("de.schlund.pfixcore.example.StatusCodeLib#checks.INT_TOO_BIG");
    
        }  
        
      
        // StringLength
        if(!params.containsKey("StringLength")) {
        pinfo  = new IWrapperParam("StringLength", false, true, null, "java.lang.String", true);
          
        params.put("StringLength", pinfo);
          
        post = new de.schlund.pfixcore.generator.postchecks.StringLength();
        pinfo.addPostChecker(post);
    
        ((de.schlund.pfixcore.generator.postchecks.StringLength) post).setMinLength("2");
    
        ((de.schlund.pfixcore.generator.postchecks.StringLength) post).setMaxLength("10");
    
        ((de.schlund.pfixcore.generator.postchecks.StringLength) post).setScodeTooShort("de.schlund.pfixcore.example.StatusCodeLib#checks.STRING_TOO_SHORT");
    
        ((de.schlund.pfixcore.generator.postchecks.StringLength) post).setScodeTooLong("de.schlund.pfixcore.example.StatusCodeLib#checks.STRING_TOO_LONG");
    
        }  
        
      
        // RegExp
        if(!params.containsKey("RegExp")) {
        pinfo  = new IWrapperParam("RegExp", false, true, null, "java.lang.String", true);
          
        params.put("RegExp", pinfo);
          
        pre = new de.schlund.pfixcore.generator.prechecks.RegexpCheck();
        pinfo.addPreChecker(pre);
    
        ((de.schlund.pfixcore.generator.prechecks.RegexpCheck) pre).setRegexp("/^[a-zA-Z]*$/");
    
        ((de.schlund.pfixcore.generator.prechecks.RegexpCheck) pre).setScodeNoMatch("de.schlund.pfixcore.example.StatusCodeLib#checks.REGEXP_NO_MATCH");
    
        }  
        
      
        // File
        if(!params.containsKey("File")) {
        pinfo  = new IWrapperParam("File", false, true, null, "java.io.File", true);
          
        params.put("File", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToFile();
        pinfo.setParamCaster(caster);
    
        ((de.schlund.pfixcore.generator.casters.ToFile) caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.FILE_ERR");
    
        }  
        
      
        // UploadFile
        if(!params.containsKey("UploadFile")) {
        pinfo  = new IWrapperParam("UploadFile", false, true, null, "de.schlund.pfixxml.multipart.UploadFile", true);
          
        params.put("UploadFile", pinfo);
          
        caster = new de.schlund.pfixcore.generator.casters.ToUploadFile();
        pinfo.setParamCaster(caster);
    
        ((de.schlund.pfixcore.generator.casters.ToUploadFile) caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.UPLOAD_FILE_ERR");
    
        }  
        
      
        super.registerParams();
    }
    
    // Date
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToDate.class,
        properties={
            @Property(name="scodeCastError",value="de.schlund.pfixcore.example.StatusCodeLib#checks.DATE_ERR"),
            @Property(name="format",value="yy/MM/dd"),
            @Property(name="paramFormat",value="yy/MM/dd")
        }
    )
    public java.util.Date getDate() {
        return (java.util.Date) gimmeParamForKey("Date").getValue();
    }
    
    public void setStringValDate(String v) {
        gimmeParamForKey("Date").
          setStringValue(new String[] {v});
    }

    public void setDate(java.util.Date v) {
        IWrapperParam iwrpParam = gimmeParamForKey("Date");
        setStringValue(new java.util.Date[] {v}, iwrpParam);
    }

    public void addSCodeDate(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("Date"), scode, null, null);
    }

    public void addSCodeDate(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("Date"), scode, args, level);
    }

    /**
      * @deprecated use addScodeDate(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsDate(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("Date"), scode, args, null);
    }
        
    // Integer
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToInteger.class,
        properties={
            @Property(name="scodeCastError",value="de.schlund.pfixcore.example.StatusCodeLib#checks.INT_ERR")
        }
    )
    public java.lang.Integer getInteger() {
        return (java.lang.Integer) gimmeParamForKey("Integer").getValue();
    }
    
    public void setStringValInteger(String v) {
        gimmeParamForKey("Integer").
          setStringValue(new String[] {v});
    }

    public void setInteger(java.lang.Integer v) {
        IWrapperParam iwrpParam = gimmeParamForKey("Integer");
        setStringValue(new java.lang.Integer[] {v}, iwrpParam);
    }

    public void addSCodeInteger(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("Integer"), scode, null, null);
    }

    public void addSCodeInteger(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("Integer"), scode, args, level);
    }

    /**
      * @deprecated use addScodeInteger(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsInteger(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("Integer"), scode, args, null);
    }
        
    // Boolean
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToBoolean.class,
        properties={
            @Property(name="scodeCastError",value="de.schlund.pfixcore.example.StatusCodeLib#checks.BOOL_ERR")
        }
    )
    public java.lang.Boolean getBoolean() {
        return (java.lang.Boolean) gimmeParamForKey("Boolean").getValue();
    }
    
    public void setStringValBoolean(String v) {
        gimmeParamForKey("Boolean").
          setStringValue(new String[] {v});
    }

    public void setBoolean(java.lang.Boolean v) {
        IWrapperParam iwrpParam = gimmeParamForKey("Boolean");
        setStringValue(new java.lang.Boolean[] {v}, iwrpParam);
    }

    public void addSCodeBoolean(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("Boolean"), scode, null, null);
    }

    public void addSCodeBoolean(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("Boolean"), scode, args, level);
    }

    /**
      * @deprecated use addScodeBoolean(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsBoolean(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("Boolean"), scode, args, null);
    }
        
    // Byte
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToByte.class,
        properties={
            @Property(name="scodeCastError",value="de.schlund.pfixcore.example.StatusCodeLib#checks.BYTE_ERR")
        }
    )
    public java.lang.Byte getByte() {
        return (java.lang.Byte) gimmeParamForKey("Byte").getValue();
    }
    
    public void setStringValByte(String v) {
        gimmeParamForKey("Byte").
          setStringValue(new String[] {v});
    }

    public void setByte(java.lang.Byte v) {
        IWrapperParam iwrpParam = gimmeParamForKey("Byte");
        setStringValue(new java.lang.Byte[] {v}, iwrpParam);
    }

    public void addSCodeByte(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("Byte"), scode, null, null);
    }

    public void addSCodeByte(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("Byte"), scode, args, level);
    }

    /**
      * @deprecated use addScodeByte(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsByte(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("Byte"), scode, args, null);
    }
        
    // Long
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToLong.class,
        properties={
            @Property(name="scodeCastError",value="de.schlund.pfixcore.example.StatusCodeLib#checks.LONG_ERR")
        }
    )
    public java.lang.Long getLong() {
        return (java.lang.Long) gimmeParamForKey("Long").getValue();
    }
    
    public void setStringValLong(String v) {
        gimmeParamForKey("Long").
          setStringValue(new String[] {v});
    }

    public void setLong(java.lang.Long v) {
        IWrapperParam iwrpParam = gimmeParamForKey("Long");
        setStringValue(new java.lang.Long[] {v}, iwrpParam);
    }

    public void addSCodeLong(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("Long"), scode, null, null);
    }

    public void addSCodeLong(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("Long"), scode, args, level);
    }

    /**
      * @deprecated use addScodeLong(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsLong(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("Long"), scode, args, null);
    }
        
    // Float
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToFloat.class,
        properties={
            @Property(name="scodeCastError",value="de.schlund.pfixcore.example.StatusCodeLib#checks.FLOAT_ERR")
        }
    )
    public java.lang.Float getFloat() {
        return (java.lang.Float) gimmeParamForKey("Float").getValue();
    }
    
    public void setStringValFloat(String v) {
        gimmeParamForKey("Float").
          setStringValue(new String[] {v});
    }

    public void setFloat(java.lang.Float v) {
        IWrapperParam iwrpParam = gimmeParamForKey("Float");
        setStringValue(new java.lang.Float[] {v}, iwrpParam);
    }

    public void addSCodeFloat(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("Float"), scode, null, null);
    }

    public void addSCodeFloat(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("Float"), scode, args, level);
    }

    /**
      * @deprecated use addScodeFloat(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsFloat(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("Float"), scode, args, null);
    }
        
    // Double
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToDouble.class,
        properties={
            @Property(name="scodeCastError",value="de.schlund.pfixcore.example.StatusCodeLib#checks.DOUBLE_ERR")
        }
    )
    public java.lang.Double getDouble() {
        return (java.lang.Double) gimmeParamForKey("Double").getValue();
    }
    
    public void setStringValDouble(String v) {
        gimmeParamForKey("Double").
          setStringValue(new String[] {v});
    }

    public void setDouble(java.lang.Double v) {
        IWrapperParam iwrpParam = gimmeParamForKey("Double");
        setStringValue(new java.lang.Double[] {v}, iwrpParam);
    }

    public void addSCodeDouble(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("Double"), scode, null, null);
    }

    public void addSCodeDouble(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("Double"), scode, args, level);
    }

    /**
      * @deprecated use addScodeDouble(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsDouble(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("Double"), scode, args, null);
    }
        
    // FloatRange
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToFloat.class,
        properties={
            @Property(name="scodeCastError",value="de.schlund.pfixcore.example.StatusCodeLib#checks.FLOAT_ERR")
        }
    )
    @PostCheck(
        type=de.schlund.pfixcore.generator.postchecks.FloatRange.class,
        properties={
            @Property(name="range",value="1.1:2.5"),
            @Property(name="scodeTooSmall",value="de.schlund.pfixcore.example.StatusCodeLib#checks.FLOAT_TOO_SMALL"),
            @Property(name="scodeTooBig",value="de.schlund.pfixcore.example.StatusCodeLib#checks.FLOAT_TOO_BIG")
        }
    )
    public java.lang.Float getFloatRange() {
        return (java.lang.Float) gimmeParamForKey("FloatRange").getValue();
    }
    
    public void setStringValFloatRange(String v) {
        gimmeParamForKey("FloatRange").
          setStringValue(new String[] {v});
    }

    public void setFloatRange(java.lang.Float v) {
        IWrapperParam iwrpParam = gimmeParamForKey("FloatRange");
        setStringValue(new java.lang.Float[] {v}, iwrpParam);
    }

    public void addSCodeFloatRange(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("FloatRange"), scode, null, null);
    }

    public void addSCodeFloatRange(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("FloatRange"), scode, args, level);
    }

    /**
      * @deprecated use addScodeFloatRange(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsFloatRange(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("FloatRange"), scode, args, null);
    }
        
    // IntegerRange
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToInteger.class,
        properties={
            @Property(name="scodeCastError",value="de.schlund.pfixcore.example.StatusCodeLib#checks.INT_ERR")
        }
    )
    @PostCheck(
        type=de.schlund.pfixcore.generator.postchecks.IntegerRange.class,
        properties={
            @Property(name="range",value="10:20"),
            @Property(name="scodeTooSmall",value="de.schlund.pfixcore.example.StatusCodeLib#checks.INT_TOO_SMALL"),
            @Property(name="scodeTooBig",value="de.schlund.pfixcore.example.StatusCodeLib#checks.INT_TOO_BIG")
        }
    )
    public java.lang.Integer getIntegerRange() {
        return (java.lang.Integer) gimmeParamForKey("IntegerRange").getValue();
    }
    
    public void setStringValIntegerRange(String v) {
        gimmeParamForKey("IntegerRange").
          setStringValue(new String[] {v});
    }

    public void setIntegerRange(java.lang.Integer v) {
        IWrapperParam iwrpParam = gimmeParamForKey("IntegerRange");
        setStringValue(new java.lang.Integer[] {v}, iwrpParam);
    }

    public void addSCodeIntegerRange(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("IntegerRange"), scode, null, null);
    }

    public void addSCodeIntegerRange(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("IntegerRange"), scode, args, level);
    }

    /**
      * @deprecated use addScodeIntegerRange(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsIntegerRange(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("IntegerRange"), scode, args, null);
    }
        
    // StringLength
    @PostCheck(
        type=de.schlund.pfixcore.generator.postchecks.StringLength.class,
        properties={
            @Property(name="minLength",value="2"),
            @Property(name="maxLength",value="10"),
            @Property(name="scodeTooShort",value="de.schlund.pfixcore.example.StatusCodeLib#checks.STRING_TOO_SHORT"),
            @Property(name="scodeTooLong",value="de.schlund.pfixcore.example.StatusCodeLib#checks.STRING_TOO_LONG")
        }
    )
    public java.lang.String getStringLength() {
        return (java.lang.String) gimmeParamForKey("StringLength").getValue();
    }
    
    public void setStringValStringLength(String v) {
        gimmeParamForKey("StringLength").
          setStringValue(new String[] {v});
    }

    public void setStringLength(java.lang.String v) {
        IWrapperParam iwrpParam = gimmeParamForKey("StringLength");
        setStringValue(new java.lang.String[] {v}, iwrpParam);
    }

    public void addSCodeStringLength(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("StringLength"), scode, null, null);
    }

    public void addSCodeStringLength(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("StringLength"), scode, args, level);
    }

    /**
      * @deprecated use addScodeStringLength(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsStringLength(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("StringLength"), scode, args, null);
    }
        
    // RegExp
    @PreCheck(
        type=de.schlund.pfixcore.generator.prechecks.RegexpCheck.class,
        properties={
            @Property(name="regexp",value="/^[a-zA-Z]*$/"),
            @Property(name="scodeNoMatch",value="de.schlund.pfixcore.example.StatusCodeLib#checks.REGEXP_NO_MATCH")
        }
    )
    public java.lang.String getRegExp() {
        return (java.lang.String) gimmeParamForKey("RegExp").getValue();
    }
    
    public void setStringValRegExp(String v) {
        gimmeParamForKey("RegExp").
          setStringValue(new String[] {v});
    }

    public void setRegExp(java.lang.String v) {
        IWrapperParam iwrpParam = gimmeParamForKey("RegExp");
        setStringValue(new java.lang.String[] {v}, iwrpParam);
    }

    public void addSCodeRegExp(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("RegExp"), scode, null, null);
    }

    public void addSCodeRegExp(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("RegExp"), scode, args, level);
    }

    /**
      * @deprecated use addScodeRegExp(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsRegExp(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("RegExp"), scode, args, null);
    }
        
    // File
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToFile.class,
        properties={
            @Property(name="scodeCastError",value="de.schlund.pfixcore.example.StatusCodeLib#checks.FILE_ERR")
        }
    )
    public java.io.File getFile() {
        return (java.io.File) gimmeParamForKey("File").getValue();
    }
    
    public void setStringValFile(String v) {
        gimmeParamForKey("File").
          setStringValue(new String[] {v});
    }

    public void setFile(java.io.File v) {
        IWrapperParam iwrpParam = gimmeParamForKey("File");
        setStringValue(new java.io.File[] {v}, iwrpParam);
    }

    public void addSCodeFile(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("File"), scode, null, null);
    }

    public void addSCodeFile(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("File"), scode, args, level);
    }

    /**
      * @deprecated use addScodeFile(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsFile(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("File"), scode, args, null);
    }
        
    // UploadFile
    @Caster(
        type=de.schlund.pfixcore.generator.casters.ToUploadFile.class,
        properties={
            @Property(name="scodeCastError",value="de.schlund.pfixcore.example.StatusCodeLib#checks.UPLOAD_FILE_ERR")
        }
    )
    public de.schlund.pfixxml.multipart.UploadFile getUploadFile() {
        return (de.schlund.pfixxml.multipart.UploadFile) gimmeParamForKey("UploadFile").getValue();
    }
    
    public void setStringValUploadFile(String v) {
        gimmeParamForKey("UploadFile").
          setStringValue(new String[] {v});
    }

    public void setUploadFile(de.schlund.pfixxml.multipart.UploadFile v) {
        IWrapperParam iwrpParam = gimmeParamForKey("UploadFile");
        setStringValue(new de.schlund.pfixxml.multipart.UploadFile[] {v}, iwrpParam);
    }

    public void addSCodeUploadFile(de.schlund.util.statuscodes.StatusCode scode) {
        addSCode(gimmeParamForKey("UploadFile"), scode, null, null);
    }

    public void addSCodeUploadFile(de.schlund.util.statuscodes.StatusCode scode, String[] args, String level) {
        addSCode(gimmeParamForKey("UploadFile"), scode, args, level);
    }

    /**
      * @deprecated use addScodeUploadFile(scode, args, null)
      */
    @Deprecated
    public void addSCodeWithArgsUploadFile(de.schlund.util.statuscodes.StatusCode scode, String[] args) {
        addSCode(gimmeParamForKey("UploadFile"), scode, args, null);
    }
        
}
  