/*
 * Decompiled with CFR 0.152.
 */
package de.schlund.pfixcore.example.bank.ihandler;

import de.schlund.pfixcore.auth.Authentication;
import de.schlund.pfixcore.example.bank.AuthTokenManager;
import de.schlund.pfixcore.example.bank.BankApplication;
import de.schlund.pfixcore.example.bank.StatusCodeLib;
import de.schlund.pfixcore.example.bank.context.ContextAccount;
import de.schlund.pfixcore.example.bank.context.ContextCustomer;
import de.schlund.pfixcore.example.bank.iwrapper.Login;
import de.schlund.pfixcore.example.bank.model.Account;
import de.schlund.pfixcore.example.bank.model.BankDAO;
import de.schlund.pfixcore.example.bank.model.Customer;
import de.schlund.pfixcore.generator.IHandler;
import de.schlund.pfixcore.generator.IWrapper;
import de.schlund.pfixcore.workflow.Context;

public class LoginHandler
implements IHandler {
    public void handleSubmittedData(Context context, IWrapper wrapper) throws Exception {
        Login login = (Login)wrapper;
        BankDAO bankDAO = BankApplication.getInstance().getBankDAO();
        if (login.getCustomerID() != null) {
            Customer customer = null;
            try {
                long customerId = Long.parseLong(login.getCustomerID());
                customer = bankDAO.getCustomerById(customerId);
                String password = login.getPassword();
                if (password == null || !password.equals(customer.getPassword())) {
                    customer = null;
                }
            }
            catch (NumberFormatException x) {
                // empty catch block
            }
            if (customer == null) {
                login.addSCodeCustomerID(StatusCodeLib.ILLEGAL_LOGIN);
                login.addSCodePassword(StatusCodeLib.ILLEGAL_LOGIN);
            } else {
                ContextCustomer contextCustomer = (ContextCustomer)context.getContextResourceManager().getResource(ContextCustomer.class);
                contextCustomer.setCustomer(customer);
                Authentication auth = context.getAuthentication();
                auth.addRole("UNRESTRICTED");
            }
        } else if (login.getAuthToken() != null) {
            String[] tokens = AuthTokenManager.decodeAuthToken((String)login.getAuthToken());
            if (tokens.length == 2) {
                try {
                    Long aid;
                    Account account;
                    Long cid = Long.parseLong(tokens[0]);
                    Customer customer = bankDAO.getCustomerById(cid.longValue());
                    if (customer != null && (account = customer.getAccountByNo((aid = Long.valueOf(Long.parseLong(tokens[1]))).longValue())) != null) {
                        ContextCustomer contextCustomer = (ContextCustomer)context.getContextResourceManager().getResource(ContextCustomer.class);
                        contextCustomer.setCustomer(customer);
                        Authentication auth = context.getAuthentication();
                        auth.addRole("ACCOUNT");
                        ContextAccount contextAccount = (ContextAccount)context.getContextResourceManager().getResource(ContextAccount.class);
                        contextAccount.setAccount(account);
                        return;
                    }
                }
                catch (NumberFormatException x) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep((long)(Math.random() * 1000.0));
            }
            catch (InterruptedException x) {
                // empty catch block
            }
            throw new IllegalArgumentException("Illegal auth token.");
        }
    }

    public boolean isActive(Context context) throws Exception {
        return true;
    }

    public boolean prerequisitesMet(Context context) throws Exception {
        return true;
    }

    public boolean needsData(Context context) throws Exception {
        return false;
    }

    public void retrieveCurrentStatus(Context context, IWrapper wrapper) throws Exception {
    }
}

