/*
 * Decompiled with CFR 0.152.
 */
package org.pustefixframework.security;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.pustefixframework.security.Utils;

public class SecureResponseWrapper
extends HttpServletResponseWrapper {
    public SecureResponseWrapper(HttpServletResponse res) {
        super(res);
    }

    public void addHeader(String name, String value) {
        super.addHeader(SecureResponseWrapper.purgeHeader(name), SecureResponseWrapper.purgeHeader(value));
    }

    public void setHeader(String name, String value) {
        super.setHeader(SecureResponseWrapper.purgeHeader(name), SecureResponseWrapper.purgeHeader(value));
    }

    public void sendRedirect(String location) throws IOException {
        super.sendRedirect(SecureResponseWrapper.purgeHeader(location));
    }

    private static String purgeHeader(String nameOrValue) {
        return Utils.removeLineBreaks(nameOrValue);
    }
}

