/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf;

import java.util.ArrayList;
import org.qamatic.mintleaf.Column;
import org.qamatic.mintleaf.MetaDataCollection;
import org.qamatic.mintleaf.MintleafException;

public class ColumnMetaDataCollection
extends ArrayList<Column>
implements MetaDataCollection {
    private String objectName;

    public ColumnMetaDataCollection() {
    }

    public ColumnMetaDataCollection(String objectName) {
        this.objectName = objectName;
    }

    public ColumnMetaDataCollection(Column ... columns) {
        for (Column column : columns) {
            this.add(column);
        }
    }

    @Override
    public boolean add(Column column) {
        Column col = this.findColumn(column.getColumnName());
        if (col != null) {
            MintleafException.throwException("column already exists " + column.getColumnName());
        }
        return super.add(column);
    }

    @Override
    public void add(int idx, Column column) {
        Column col = this.findColumn(column.getColumnName());
        if (col != null) {
            MintleafException.throwException("column already exists " + column.getColumnName());
        }
        this.add(idx, column);
    }

    @Override
    public int getIndex(String columnName) {
        columnName = columnName.toUpperCase();
        for (int i = 0; i < this.size(); ++i) {
            if (!((Column)this.get(i)).getColumnName().equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Column findColumn(String columnName) {
        int idx = this.getIndex(columnName);
        if (idx != -1) {
            return (Column)this.get(idx);
        }
        return null;
    }

    @Override
    public Column getColumn(int index) {
        return (Column)this.get(index);
    }

    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Column mdata : this) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(mdata.getColumnName());
        }
        return sb.toString();
    }

    @Override
    public int getColumnCount() {
        return this.size();
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return false;
    }

    @Override
    public boolean isSearchable(int column) {
        return false;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) {
        return 0;
    }

    @Override
    public boolean isSigned(int column) {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        return 0;
    }

    @Override
    public String getColumnLabel(int column) {
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return ((Column)this.get(column)).getColumnName();
    }

    @Override
    public String getSchemaName(int column) {
        return null;
    }

    @Override
    public int getPrecision(int column) {
        return 0;
    }

    @Override
    public int getScale(int column) {
        return 0;
    }

    @Override
    public String getTableName(int column) {
        return null;
    }

    @Override
    public String getCatalogName(int column) {
        return null;
    }

    @Override
    public int getColumnType(int column) {
        return ((Column)this.get(column)).getDatatype();
    }

    @Override
    public String getColumnTypeName(int column) {
        return null;
    }

    @Override
    public boolean isReadOnly(int column) {
        return false;
    }

    @Override
    public boolean isWritable(int column) {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return false;
    }

    @Override
    public String getColumnClassName(int column) {
        return null;
    }
}

