/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf;

public enum DbType {
    H2("H2 Database", "jdbc:h2:"),
    MYSQL("MySQL database", "jdbc:mysql:"),
    ORACLE("Oracle database", "jdbc:oracle:"),
    MSSQL("Microsoft SQL Server database", "jdbc:sqlserver:");

    private final String name;
    private String jdbcUrlPrefix;

    private DbType(String name, String jdbcUrlPrefix) {
        this.name = name;
        this.jdbcUrlPrefix = jdbcUrlPrefix;
    }

    public static DbType getDbType(String url) {
        url = url.toLowerCase();
        for (DbType dt : DbType.values()) {
            if (!url.contains(dt.jdbcUrlPrefix)) continue;
            return dt;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getJdbcUrlPrefix() {
        return this.jdbcUrlPrefix;
    }
}

