/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.qamatic.mintleaf.ColumnMatcher;
import org.qamatic.mintleaf.ConnectionContext;
import org.qamatic.mintleaf.DataComparer;
import org.qamatic.mintleaf.Database;
import org.qamatic.mintleaf.DriverSource;
import org.qamatic.mintleaf.Executable;
import org.qamatic.mintleaf.MetaDataCollection;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.MintleafReader;
import org.qamatic.mintleaf.ParameterBinding;
import org.qamatic.mintleaf.ReadListener;
import org.qamatic.mintleaf.Row;
import org.qamatic.mintleaf.RowListWrapper;
import org.qamatic.mintleaf.core.BasicDatabase;
import org.qamatic.mintleaf.core.FluentJdbc;
import org.qamatic.mintleaf.core.JdbcDriverSource;
import org.qamatic.mintleaf.core.ObjectRowListWrapper;
import org.qamatic.mintleaf.core.ResultSetRowListWrapper;
import org.qamatic.mintleaf.data.CompareColumnState;
import org.qamatic.mintleaf.data.ComparerListener;
import org.qamatic.mintleaf.data.OrderedColumnMatcher;
import org.qamatic.mintleaf.data.OrderedListComparator;
import org.qamatic.mintleaf.data.SelectedColumnMatcher;
import org.qamatic.mintleaf.tools.BinaryFileImporter;
import org.qamatic.mintleaf.tools.CsvExporter;
import org.qamatic.mintleaf.tools.CsvImporter;
import org.qamatic.mintleaf.tools.DbImporter;

public final class Mintleaf {
    private static final MintleafLogger logger = MintleafLogger.getLogger(Mintleaf.class);

    public static FluentJdbc.Builder queryBuilder(ConnectionContext connectionContext) {
        return new FluentJdbc.Builder(connectionContext);
    }

    public static Database database(String url, String username, String password) {
        return new DatabaseBuilder().withDriverSource(JdbcDriverSource.class).withUrl(url).withUsername(username).withPassword(password).build();
    }

    public static final class DatabaseBuilder {
        private Class<? extends DriverSource> driverSourceClazz = JdbcDriverSource.class;
        private String url;
        private String username;
        private String password;

        public DatabaseBuilder withDriverSource(Class<? extends DriverSource> driverSourceClazz) {
            this.driverSourceClazz = driverSourceClazz;
            return this;
        }

        public DatabaseBuilder withUrl(String url) {
            this.url = url;
            return this;
        }

        public DatabaseBuilder withUsername(String username) {
            this.username = username;
            return this;
        }

        public DatabaseBuilder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Database build() {
            BasicDatabase databaseContext = new BasicDatabase(this.driverSourceClazz, this.url, this.username, this.password);
            return databaseContext;
        }
    }

    public static final class DataComparerBuilder {
        private static final MintleafLogger logger = MintleafLogger.getLogger(DataComparerBuilder.class);
        private RowListWrapper sourceTable;
        private RowListWrapper targetTable;
        private ComparerListener comparerListener;
        private ColumnMatcher columnMatcher;
        private String selectedColumnMaps;

        public DataComparerBuilder withSourceTable(List<? extends Row> sourceTable, MetaDataCollection metaDataCollection) {
            this.sourceTable = new ObjectRowListWrapper<Row>(sourceTable, metaDataCollection);
            return this;
        }

        public DataComparerBuilder withSourceTable(RowListWrapper sourceTable) {
            this.sourceTable = sourceTable;
            return this;
        }

        public DataComparerBuilder withTargetTable(List<? extends Row> targetTable, MetaDataCollection metaDataCollection) {
            this.targetTable = new ObjectRowListWrapper<Row>(targetTable, metaDataCollection);
            return this;
        }

        public DataComparerBuilder withTargetTable(RowListWrapper targetTable) {
            this.targetTable = targetTable;
            return this;
        }

        public DataComparerBuilder withColumnMatchingLogic(ColumnMatcher columnMatcher) {
            this.columnMatcher = columnMatcher;
            return this;
        }

        public DataComparerBuilder withSelectedColumnMaps(String selectedColumnMaps) {
            this.selectedColumnMaps = selectedColumnMaps;
            return this;
        }

        public DataComparerBuilder withMatchingResult(ComparerListener comparerListener) {
            this.comparerListener = comparerListener;
            return this;
        }

        public DataComparer buildWith(Class<? extends DataComparer> dataComparerClazz) {
            DataComparer listComparator = null;
            try {
                Constructor<? extends DataComparer> constructor = dataComparerClazz.getConstructor(RowListWrapper.class, RowListWrapper.class);
                listComparator = constructor.newInstance(this.sourceTable, this.targetTable);
                if (this.columnMatcher != null) {
                    listComparator.setColumnMatcher(this.columnMatcher);
                } else if (this.selectedColumnMaps == null) {
                    listComparator.setColumnMatcher(this.getOrderedColumnMatcher(this.sourceTable instanceof ResultSetRowListWrapper, this.targetTable instanceof ResultSetRowListWrapper));
                } else {
                    listComparator.setColumnMatcher(new SelectedColumnMatcher(this.selectedColumnMaps));
                }
                listComparator.setComparerListener(this.comparerListener);
            }
            catch (InstantiationException e) {
                logger.error(e);
                MintleafException.throwException(e);
            }
            catch (IllegalAccessException e) {
                logger.error(e);
                MintleafException.throwException(e);
            }
            catch (NoSuchMethodException e) {
                logger.error(e);
                MintleafException.throwException(e);
            }
            catch (InvocationTargetException e) {
                logger.error(e);
                MintleafException.throwException(e);
            }
            return listComparator;
        }

        private OrderedColumnMatcher getOrderedColumnMatcher(final boolean dbSourceColumnState, final boolean dbTargetColumnState) {
            return new OrderedColumnMatcher(){

                @Override
                protected CompareColumnState createSourceColumnStateInstance() {
                    if (dbSourceColumnState) {
                        this.setColumnCountOffset(1);
                    }
                    return super.createSourceColumnStateInstance();
                }

                @Override
                protected CompareColumnState createTargetColumnStateInstance() {
                    if (dbTargetColumnState) {
                        this.setColumnCountOffset(1);
                    }
                    return super.createTargetColumnStateInstance();
                }
            };
        }

        public DataComparer build() {
            return this.buildWith(OrderedListComparator.class);
        }
    }

    public static final class AnyDataToListTransferBuilder<T extends Row> {
        private MintleafReader importReader;
        private ReadListener readListener;

        public AnyDataToListTransferBuilder withSource(MintleafReader importReader) {
            this.importReader = importReader;
            return this;
        }

        public AnyDataToListTransferBuilder withMatchingCriteria(ReadListener rowDelegate) {
            this.readListener = rowDelegate;
            return this;
        }

        public Executable<RowListWrapper<T>> build() throws MintleafException {
            return new Executable<RowListWrapper<T>>(){

                @Override
                public RowListWrapper<T> execute() throws MintleafException {
                    final ObjectRowListWrapper list = new ObjectRowListWrapper();
                    importReader.setReadListener(new ReadListener<T>(){

                        @Override
                        public T eachRow(int rowNum, Row row) throws MintleafException {
                            list.add(row);
                            return row;
                        }
                    });
                    importReader.read();
                    return list;
                }
            };
        }
    }

    public static final class AnyDataToDbDataTransferBuilder {
        private Database targetDb;
        private String targetSqlTemplate;
        private MintleafReader importReader;

        public AnyDataToDbDataTransferBuilder withTargetDb(Database targetDb) {
            this.targetDb = targetDb;
            return this;
        }

        public AnyDataToDbDataTransferBuilder withTargetSqlTemplate(String targetSqlTemplate) {
            this.targetSqlTemplate = targetSqlTemplate;
            return this;
        }

        public AnyDataToDbDataTransferBuilder withImportFlavour(MintleafReader importReader) {
            this.importReader = importReader;
            return this;
        }

        public Executable<Boolean> build() {
            BinaryFileImporter binaryFileImporter = new BinaryFileImporter(this.importReader, this.targetDb.getNewConnection(), this.targetSqlTemplate){};
            return binaryFileImporter;
        }
    }

    public static final class CsvToDbDataTransferBuilder {
        private Database targetDb;
        private String targetSqlTemplate;
        private String sourceCsvFile;

        public CsvToDbDataTransferBuilder withTargetDb(Database targetDb) {
            this.targetDb = targetDb;
            return this;
        }

        public CsvToDbDataTransferBuilder withTargetSqlTemplate(String targetSqlTemplate) {
            this.targetSqlTemplate = targetSqlTemplate;
            return this;
        }

        public CsvToDbDataTransferBuilder withSourceCsvFile(String sourceCsvFile) {
            this.sourceCsvFile = sourceCsvFile;
            return this;
        }

        public Executable<Boolean> build() {
            CsvImporter csvImporter = new CsvImporter(this.sourceCsvFile, this.targetDb.getNewConnection(), this.targetSqlTemplate);
            return csvImporter;
        }
    }

    public static final class DbToCsvDataTransferBuilder {
        private String sourceSql;
        private ParameterBinding sqlaramValueBindings;
        private Database sourceDb;
        private String targetCsvFile;

        public DbToCsvDataTransferBuilder withSqlaramValueBindings(ParameterBinding sqlaramValueBindings) {
            this.sqlaramValueBindings = sqlaramValueBindings;
            return this;
        }

        public DbToCsvDataTransferBuilder withSourceDb(Database sourceDb) {
            this.sourceDb = sourceDb;
            return this;
        }

        public DbToCsvDataTransferBuilder withSourceSql(String sourceSql) {
            this.sourceSql = sourceSql;
            return this;
        }

        public DbToCsvDataTransferBuilder withTargetCsvFile(String targetCsvFile) {
            this.targetCsvFile = targetCsvFile;
            return this;
        }

        public Executable<Boolean> build() {
            CsvExporter csvExporter = new CsvExporter(this.sourceDb.getNewConnection(), this.sourceSql, this.targetCsvFile);
            csvExporter.setSqlaramValueBindings(this.sqlaramValueBindings);
            return csvExporter;
        }
    }

    public static final class DbToDbDataTransferBuilder {
        private String sourceSql;
        private ParameterBinding sqlaramValueBindings;
        private Database sourceDb;
        private Database targetDb;
        private String targetSqlTemplate;

        public DbToDbDataTransferBuilder withSqlaramValueBindings(ParameterBinding sqlaramValueBindings) {
            this.sqlaramValueBindings = sqlaramValueBindings;
            return this;
        }

        public DbToDbDataTransferBuilder withSourceDb(Database sourceDbDriverSource) {
            this.sourceDb = sourceDbDriverSource;
            return this;
        }

        public DbToDbDataTransferBuilder withSourceSql(String sourceSql) {
            this.sourceSql = sourceSql;
            return this;
        }

        public DbToDbDataTransferBuilder withTargetDb(Database targetDbDriverSource) {
            this.targetDb = targetDbDriverSource;
            return this;
        }

        public DbToDbDataTransferBuilder withTargetSqlTemplate(String targetSqlTemplate) {
            this.targetSqlTemplate = targetSqlTemplate;
            return this;
        }

        public Executable<Boolean> build() {
            DbImporter dbImporter = new DbImporter(this.sourceDb.getNewConnection(), this.sourceSql, this.targetDb.getNewConnection(), this.targetSqlTemplate);
            dbImporter.setSourceSqlParamValueBindings(this.sqlaramValueBindings);
            return dbImporter;
        }
    }
}

