/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.qamatic.mintleaf.Column;
import org.qamatic.mintleaf.MetaDataCollection;
import org.qamatic.mintleaf.MintleafException;

public class ResultSetMetaDataCollection
extends ArrayList<Column>
implements MetaDataCollection {
    private String objectName;
    private ResultSetMetaData resultSetMetaData;

    public ResultSetMetaDataCollection(ResultSetMetaData resultSetMetaData) {
        this.resultSetMetaData = resultSetMetaData;
        try {
            for (int i = 1; i < this.resultSetMetaData.getColumnCount(); ++i) {
                this.add(new Column(this.resultSetMetaData.getColumnName(i), this.resultSetMetaData.getColumnType(i)));
            }
        }
        catch (SQLException e) {
            MintleafException.throwException(e);
        }
    }

    @Override
    public boolean add(Column column) {
        Column col = this.findColumn(column.getColumnName());
        if (col != null) {
            MintleafException.throwException("column already exists " + column.getColumnName());
        }
        return super.add(column);
    }

    @Override
    public void add(int idx, Column column) {
        Column col = this.findColumn(column.getColumnName());
        if (col != null) {
            MintleafException.throwException("column already exists " + column.getColumnName());
        }
        this.add(idx, column);
    }

    @Override
    public int getIndex(String columnName) {
        columnName = columnName.toUpperCase();
        for (int i = 0; i < this.size(); ++i) {
            if (!((Column)this.get(i)).getColumnName().equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Column findColumn(String columnName) {
        int idx = this.getIndex(columnName);
        if (idx != -1) {
            return (Column)this.get(idx);
        }
        return null;
    }

    @Override
    public Column getColumn(int index) {
        return (Column)this.get(index);
    }

    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Column mdata : this) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(mdata.getColumnName());
        }
        return sb.toString();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.resultSetMetaData.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.resultSetMetaData.isAutoIncrement(column);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.resultSetMetaData.isCaseSensitive(column);
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.resultSetMetaData.isSearchable(column);
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.resultSetMetaData.isCurrency(column);
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.resultSetMetaData.isNullable(column);
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.resultSetMetaData.isSigned(column);
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.resultSetMetaData.getColumnDisplaySize(column);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.resultSetMetaData.getColumnLabel(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.resultSetMetaData.getColumnName(column);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.resultSetMetaData.getSchemaName(column);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.resultSetMetaData.getPrecision(column);
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.resultSetMetaData.getScale(column);
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.resultSetMetaData.getTableName(column);
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.resultSetMetaData.getCatalogName(column);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.resultSetMetaData.getColumnType(column);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.resultSetMetaData.getColumnTypeName(column);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.resultSetMetaData.isReadOnly(column);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.resultSetMetaData.isWritable(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.resultSetMetaData.isDefinitelyWritable(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.resultSetMetaData.getColumnClassName(column);
    }
}

