/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qamatic.mintleaf.MintleafLogger;

public class ArgPatternHandler {
    private static final MintleafLogger logger = MintleafLogger.getLogger(ArgPatternHandler.class);
    private static final Pattern p = Pattern.compile("\\$\\{(.+?)\\}", 10);
    private String text;
    private Map<String, String> userProperties;
    private boolean bDone;

    public ArgPatternHandler(String text) {
        this.text = text;
    }

    public Map<String, String> getUserProperties() {
        if (this.userProperties == null) {
            this.userProperties = new HashMap<String, String>();
        }
        return this.userProperties;
    }

    public ArgPatternHandler withUserProperties(Map<String, String> userProperties) {
        this.userProperties = userProperties;
        return this;
    }

    public String getText() {
        if (!this.bDone) {
            this.bDone = true;
            this.relacewithUserVars();
            this.relacewithVMArgs();
            this.relacewithSystemArgs();
        }
        return this.text;
    }

    private void relacewithSystemArgs() {
        Matcher m = p.matcher(this.text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            if (System.getenv(m.group(1)) == null) continue;
            m.appendReplacement(sb, System.getenv(m.group(1)));
        }
        m.appendTail(sb);
        this.text = sb.toString();
    }

    private void relacewithVMArgs() {
        Matcher m = p.matcher(this.text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            if (System.getProperty(m.group(1)) == null) continue;
            m.appendReplacement(sb, System.getProperty(m.group(1)));
        }
        m.appendTail(sb);
        this.text = sb.toString();
    }

    private void relacewithUserVars() {
        Matcher m = p.matcher(this.text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            if (!this.getUserProperties().containsKey(m.group(1))) continue;
            m.appendReplacement(sb, this.getUserProperties().get(m.group(1)));
        }
        m.appendTail(sb);
        this.text = sb.toString();
    }

    public String toString() {
        return this.getText();
    }
}

