/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.configuration;

import java.util.List;
import javax.xml.bind.annotation.XmlType;
import org.qamatic.mintleaf.Database;
import org.qamatic.mintleaf.DbType;
import org.qamatic.mintleaf.Mintleaf;
import org.qamatic.mintleaf.configuration.ConnectionProperties;
import org.qamatic.mintleaf.configuration.Property;
import org.qamatic.mintleaf.core.JdbcDriverSource;

@XmlType(propOrder={"id", "type", "url", "username", "password", "connectionProperties"})
public class DbConnectionInfo {
    private String id;
    private DbType type = DbType.H2;
    private String url;
    private String username;
    private String password;
    private ConnectionProperties connectionProperties = new ConnectionProperties();

    public DbConnectionInfo() {
    }

    public DbConnectionInfo(String id, DbType type, String url) {
        this.id = id;
        this.type = type;
        this.url = url;
    }

    public DbConnectionInfo(String id, DbType type, String url, String username, String password) {
        this.id = id;
        this.type = type;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DbType getType() {
        return this.type;
    }

    public void setType(DbType type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ConnectionProperties getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(ConnectionProperties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public List<Property> getConnectionPropertiesList() {
        return this.getConnectionProperties().getItems();
    }

    public Database getNewDatabaseInstance() {
        return new Mintleaf.DatabaseBuilder().withDriverSource(JdbcDriverSource.class).withUrl(this.url).withUsername(this.username).withPassword(this.password).build();
    }
}

