/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.configuration;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.qamatic.mintleaf.MintleafConfiguration;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.configuration.DbConnectionInfo;
import org.qamatic.mintleaf.configuration.SchemaVersionInfo;
import org.qamatic.mintleaf.configuration.SchemaVersions;
import org.qamatic.mintleaf.readers.TextContentStreamReader;

@XmlRootElement(name="mintleaf")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"description", "databases", "schemaVersions"})
public class MintleafXmlConfiguration
implements MintleafConfiguration {
    @XmlAttribute
    private String version = "1.0";
    private String description = "Database connections and Schema version configuration file";
    @XmlElement(name="database")
    private List<DbConnectionInfo> databases = new Databases();
    private SchemaVersions schemaVersions = new SchemaVersions();

    public static MintleafConfiguration deSerialize(String configFileName) throws MintleafException {
        TextContentStreamReader reader = new TextContentStreamReader(configFileName);
        reader.read();
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{MintleafXmlConfiguration.class});
            Unmarshaller marshaller = jc.createUnmarshaller();
            StringReader sr = new StringReader(((Object)reader).toString());
            MintleafXmlConfiguration configurationRoot = (MintleafXmlConfiguration)marshaller.unmarshal((Reader)sr);
            return configurationRoot;
        }
        catch (JAXBException e) {
            throw new MintleafException(e);
        }
    }

    @Override
    public List<DbConnectionInfo> getDatabases() {
        return this.databases;
    }

    public void setDatabases(List<DbConnectionInfo> databases) {
        this.databases = databases;
    }

    @Override
    public List<SchemaVersionInfo> getSchemas() {
        return this.getSchemaVersions().getVersion();
    }

    public SchemaVersions getSchemaVersions() {
        return this.schemaVersions;
    }

    public void setSchemaVersions(SchemaVersions schemaVersions) {
        this.schemaVersions = schemaVersions;
    }

    @Override
    public String getConfigVersion() {
        return this.getVersion();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.serialize();
    }

    private String serialize() {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{MintleafXmlConfiguration.class});
            Marshaller marshaller = jc.createMarshaller();
            StringWriter sw = new StringWriter();
            marshaller.marshal((Object)this, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public DbConnectionInfo getDbConnectionInfo(String databaseId) {
        for (DbConnectionInfo dbConnectionInfo : this.getDatabases()) {
            if (!dbConnectionInfo.getId().equalsIgnoreCase(databaseId)) continue;
            return dbConnectionInfo;
        }
        return null;
    }

    @Override
    public SchemaVersionInfo getSchemaVersionInfo(String versionId) {
        for (SchemaVersionInfo schemaVersionInfo : this.getSchemas()) {
            if (!schemaVersionInfo.getId().equalsIgnoreCase(versionId)) continue;
            return schemaVersionInfo;
        }
        return null;
    }

    public class Databases
    extends ArrayList<DbConnectionInfo> {
    }
}

