/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.MintleafReader;
import org.qamatic.mintleaf.core.BaseReader;

public abstract class BaseSqlReader<T>
extends BaseReader
implements MintleafReader<T> {
    private static final MintleafLogger logger = MintleafLogger.getLogger(BaseSqlReader.class);
    private String delimiter = "/";
    private Map<String, String> userVariableMapping;

    public static InputStream getInputStreamFromFile(String resourceOrFileName) {
        InputStream stream = null;
        logger.info("reading file: " + resourceOrFileName);
        if (resourceOrFileName.startsWith("res:")) {
            String resFile = resourceOrFileName.substring(4);
            stream = Thread.currentThread().getContextClassLoader().getClass().getResourceAsStream(resFile);
            if (stream == null) {
                logger.error("file not found " + resourceOrFileName);
            }
        } else {
            try {
                stream = new FileInputStream(resourceOrFileName);
            }
            catch (FileNotFoundException e) {
                logger.error("file not found " + resourceOrFileName, e);
            }
        }
        return stream;
    }

    protected boolean isDelimiter(String line) {
        return this.getDelimiter().equals("/") && line.equals("/") || this.getDelimiter().equals(";") && line.endsWith(";") || this.getDelimiter().equalsIgnoreCase("GO") && line.equalsIgnoreCase("GO");
    }

    @Override
    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public void setDelimiter(String delimStr) {
        this.delimiter = delimStr.toUpperCase();
    }

    @Override
    public abstract T read() throws MintleafException;

    @Override
    public Map<String, String> getUserVariableMapping() {
        if (this.userVariableMapping == null) {
            this.userVariableMapping = new HashMap<String, String>();
        }
        return this.userVariableMapping;
    }

    @Override
    public void setUserVariableMapping(Map userVariableMapping) {
        this.userVariableMapping = userVariableMapping;
    }
}

