/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core;

import org.qamatic.mintleaf.ConnectionContext;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.MintleafReader;
import org.qamatic.mintleaf.ReadListener;
import org.qamatic.mintleaf.SqlScript;
import org.qamatic.mintleaf.core.CommandExecutor;

public abstract class BaseSqlScript
implements SqlScript {
    private static final MintleafLogger logger = MintleafLogger.getLogger(BaseSqlScript.class);
    protected ConnectionContext connectionContext;
    protected ReadListener readListener;

    public BaseSqlScript(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    @Override
    public void apply() throws MintleafException {
        MintleafReader reader = this.getReader();
        this.execute(reader);
        this.close();
    }

    public ReadListener getReadListener() {
        if (this.readListener == null) {
            this.readListener = new CommandExecutor(this.connectionContext);
        }
        return this.readListener;
    }

    protected void execute(MintleafReader reader) throws MintleafException {
        reader.setReadListener(this.getReadListener());
        reader.read();
    }
}

