/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core;

import org.qamatic.mintleaf.Database;
import org.qamatic.mintleaf.DriverSource;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.core.JdbcDriverSource;

public class BasicDatabase
implements Database {
    private static final MintleafLogger logger = MintleafLogger.getLogger(BasicDatabase.class);
    private Class<? extends DriverSource> driverSourceClazz;
    private String url;
    private String username;
    private String password;
    private DriverSource driverSource;

    public BasicDatabase(Class<? extends DriverSource> driverSourceClazz, String url, String username, String password) {
        this.driverSourceClazz = driverSourceClazz;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public BasicDatabase(String url, String username, String password) {
        this.driverSourceClazz = JdbcDriverSource.class;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public BasicDatabase(DriverSource driverSource) {
        this.driverSource = driverSource;
        this.url = driverSource.getUrl();
        this.username = driverSource.getUsername();
        this.password = driverSource.getPassword();
    }

    private static DriverSource getDriverSource(Class<? extends DriverSource> driverSourceClazz) {
        DriverSource driverSource = null;
        try {
            driverSource = driverSourceClazz.newInstance();
        }
        catch (InstantiationException e) {
            logger.error(e);
            MintleafException.throwException(e);
        }
        catch (IllegalAccessException e) {
            logger.error(e);
            MintleafException.throwException(e);
        }
        return driverSource;
    }

    @Override
    public DriverSource getDriverSource() {
        if (this.driverSource == null) {
            this.driverSource = this.buildDriverSource();
        }
        return this.driverSource;
    }

    private DriverSource buildDriverSource() {
        DriverSource driverSource = BasicDatabase.getDriverSource(this.driverSourceClazz);
        driverSource.setUrl(this.url);
        if (this.username != null) {
            driverSource.setUsername(this.username);
            driverSource.setPassword(this.password);
        }
        return driverSource;
    }
}

