/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core;

import org.qamatic.mintleaf.ConnectionContext;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafReader;
import org.qamatic.mintleaf.core.BaseSqlScript;
import org.qamatic.mintleaf.core.SqlChangeSets;
import org.qamatic.mintleaf.readers.MultiChangeSetFileReader;
import org.qamatic.mintleaf.readers.SqlChangeSetFileReader;
import org.qamatic.mintleaf.readers.SqlStringReader;

public final class ChangeSets {
    public static void applySource(ConnectionContext connectionContext, final String script, final String delimiter) throws MintleafException {
        BaseSqlScript sqlScript = new BaseSqlScript(connectionContext){

            @Override
            public MintleafReader getReader() {
                SqlStringReader reader = new SqlStringReader(script);
                reader.setDelimiter(delimiter);
                return reader;
            }
        };
        sqlScript.apply();
    }

    public static void migrate(ConnectionContext connectionContext, String fileName, String changeSetsToLoadSeparatedByComma) throws MintleafException {
        ChangeSets.migrate(connectionContext, fileName, changeSetsToLoadSeparatedByComma.split(","));
    }

    public static void migrate(ConnectionContext connectionContext, String fileName, String[] changeSetsToLoad) throws MintleafException {
        SqlChangeSets changeSets = new SqlChangeSets(connectionContext, new SqlChangeSetFileReader(fileName), changeSetsToLoad);
        changeSets.apply();
    }

    public static void migrate(ConnectionContext connectionContext, String[] folderPaths, String[] changeSetsToLoad) throws MintleafException {
        SqlChangeSets changeSets = new SqlChangeSets(connectionContext, new MultiChangeSetFileReader(folderPaths), changeSetsToLoad);
        changeSets.apply();
    }
}

