/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.qamatic.mintleaf.ConnectionContext;
import org.qamatic.mintleaf.DbQueryExtension;
import org.qamatic.mintleaf.DriverSource;
import org.qamatic.mintleaf.Executable;
import org.qamatic.mintleaf.ExecutionResultListener;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.ParameterBinding;
import org.qamatic.mintleaf.RowMatchListener;
import org.qamatic.mintleaf.SqlResultSet;
import org.qamatic.mintleaf.core.ExecuteQuery;
import org.qamatic.mintleaf.core.FluentJdbc;
import org.qamatic.mintleaf.core.StoredProcedure;
import org.qamatic.mintleaf.core.stdqueries.StandardQueries;

public class DbConnectionContext<T extends DbQueryExtension>
implements ConnectionContext<T> {
    private static final MintleafLogger logger = MintleafLogger.getLogger(DbConnectionContext.class);
    private Connection connection;
    private DriverSource driverSource;
    private boolean autoCloseable = true;
    private boolean inTransaction = false;

    public DbConnectionContext(DriverSource driverSource, boolean autoCloseable) {
        this.driverSource = driverSource;
        this.autoCloseable = autoCloseable;
    }

    private static DbQueryExtension createDbQueryInstance(String url, ConnectionContext connectionContext) {
        Class<? extends StandardQueries> queryImplClaz = StandardQueries.getQueryImplementation(url);
        DbQueryExtension dbQueries = null;
        try {
            Constructor<? extends StandardQueries> constructor = queryImplClaz.getConstructor(ConnectionContext.class);
            dbQueries = constructor.newInstance(connectionContext);
        }
        catch (InstantiationException e) {
            logger.error(e);
            MintleafException.throwException(e);
        }
        catch (IllegalAccessException e) {
            logger.error(e);
            MintleafException.throwException(e);
        }
        catch (NoSuchMethodException e) {
            logger.error(e);
            MintleafException.throwException(e);
        }
        catch (InvocationTargetException e) {
            logger.error(e);
            MintleafException.throwException(e);
        }
        return dbQueries;
    }

    @Override
    public Connection getConnection() throws MintleafException {
        if (this.connection == null) {
            try {
                this.connection = this.driverSource.getConnection();
            }
            catch (SQLException e) {
                throw new MintleafException(e);
            }
        }
        return this.connection;
    }

    @Override
    public boolean isCloseable() {
        return this.autoCloseable;
    }

    @Override
    public void close() {
        if (this.isCloseable() && this.connection != null) {
            try {
                this.commitTransaction();
                this.connection.close();
                this.connection = null;
            }
            catch (Exception e) {
                MintleafException.throwException(e);
            }
        }
    }

    @Override
    public ConnectionContext beginTransaction() throws MintleafException {
        try {
            if (!this.inTransaction) {
                this.inTransaction = true;
                this.getConnection().setAutoCommit(false);
            }
            return this;
        }
        catch (SQLException e) {
            throw new MintleafException(e);
        }
    }

    @Override
    public void commitTransaction() throws MintleafException {
        if (!this.inTransaction) {
            return;
        }
        try {
            this.getConnection().commit();
            this.inTransaction = false;
        }
        catch (SQLException e) {
            throw new MintleafException(e);
        }
    }

    @Override
    public void rollbackTransaction() throws MintleafException {
        if (!this.inTransaction) {
            return;
        }
        try {
            this.getConnection().rollback();
            this.inTransaction = false;
        }
        catch (SQLException e) {
            throw new MintleafException(e);
        }
    }

    @Override
    public T getDbQueries() {
        return (T)DbConnectionContext.createDbQueryInstance(this.driverSource.getUrl(), this);
    }

    public String toString() {
        return String.format("Driver: %s, InTransaction:%s, AutoCloseConnection:%s ", this.driverSource, this.inTransaction, this.isCloseable());
    }

    @Override
    public FluentJdbc.Builder queryBuilder() {
        return new FluentJdbc.Builder(this);
    }

    @Override
    public SqlResultSet selectQuery(String sql) {
        return this.queryBuilder().withSql(sql).buildSelect();
    }

    @Override
    public Executable<int[]> executeBatchSqls(List<String> batchSqls) {
        return new ExecuteQuery(this, batchSqls);
    }

    @Override
    public Executable<int[]> executeSql(String sql) {
        return this.queryBuilder().withSql(sql).buildExecute();
    }

    @Override
    public Executable<int[]> executeSql(String sql, Object[] parameterValues) {
        return this.queryBuilder().withSql(sql).withParamValues(parameterValues).buildExecute();
    }

    @Override
    public <T> List<T> query(String sql, ParameterBinding parameterBinding, RowMatchListener<T> listener) throws MintleafException {
        ArrayList rows = new ArrayList();
        try (SqlResultSet sqlResultSet = this.queryBuilder().withSql(sql).withParamValues(parameterBinding).buildSelect();){
            sqlResultSet.iterate((row, dr) -> {
                try {
                    if (listener.matches(dr)) {
                        rows.add(listener.eachRow(row, dr));
                    }
                    if (!listener.canContinueRead(dr)) {
                        return rows;
                    }
                }
                catch (MintleafException e) {
                    logger.error("error iterating resultset", e);
                }
                return null;
            });
        }
        return rows;
    }

    @Override
    public Executable<int[]> executeStoredProc(String procedureCall, StoredProcedure.CallType callType, ParameterBinding.Callable parameterBinding) {
        return this.executeStoredProc(procedureCall, callType, parameterBinding, null);
    }

    @Override
    public Executable<int[]> executeStoredProc(String procedureCall, StoredProcedure.CallType callType, ParameterBinding.Callable parameterBinding, ExecutionResultListener.Callable executionResultListener) {
        StoredProcedure proc = new StoredProcedure(this, procedureCall, callType, parameterBinding);
        proc.setExecutionResultListener(executionResultListener);
        return proc;
    }
}

