/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.qamatic.mintleaf.ConnectionContext;
import org.qamatic.mintleaf.Executable;
import org.qamatic.mintleaf.ExecutionResultListener;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.ParameterBinding;
import org.qamatic.mintleaf.core.BindingParameterSets;

public class ExecuteQuery
implements Executable<int[]> {
    private static final MintleafLogger logger = MintleafLogger.getLogger(ExecuteQuery.class);
    private ConnectionContext connectionContext;
    private ExecutionResultListener executionResultListener;
    private String sql;
    private ParameterBinding parameterBinding;
    private List<String> batchSqls;

    public ExecuteQuery(ConnectionContext connectionContext, String sql, ParameterBinding parameterBinding) {
        this.connectionContext = connectionContext;
        this.parameterBinding = parameterBinding;
        this.sql = sql;
    }

    public ExecuteQuery(ConnectionContext connectionContext, List<String> batchSqls) {
        this.connectionContext = connectionContext;
        this.batchSqls = batchSqls;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] execute() throws MintleafException {
        if (this.batchSqls != null) {
            try (Statement statement = this.connectionContext.getConnection().createStatement();){
                BindingParameterSets parameterSets = new BindingParameterSets(statement);
                for (String sqlItem : this.batchSqls) {
                    statement.addBatch(sqlItem);
                }
                int[] result = statement.executeBatch();
                if (this.executionResultListener != null) {
                    this.executionResultListener.onAfterExecuteSql(parameterSets);
                }
                int[] nArray = result;
                return nArray;
            }
            catch (SQLException e) {
                logger.error(e);
                throw new MintleafException(e);
            }
        }
        try (PreparedStatement preparedStatement = this.connectionContext.getConnection().prepareStatement(this.sql);){
            BindingParameterSets parameterSets = new BindingParameterSets(preparedStatement);
            if (this.parameterBinding != null) {
                this.parameterBinding.bindParameters(parameterSets);
            }
            if (parameterSets.isBatch()) {
                int[] result = preparedStatement.executeBatch();
                return result;
            }
            int[] result = new int[]{preparedStatement.execute() ? 1 : 0};
            if (this.executionResultListener != null) {
                this.executionResultListener.onAfterExecuteSql(parameterSets);
            }
            int[] nArray = result;
            return nArray;
        }
        catch (MintleafException e) {
            logger.error("error fetching data", e);
            throw new MintleafException(e);
        }
        catch (SQLException e) {
            logger.error(e);
            throw new MintleafException(e);
        }
    }

    public void setExecutionResultListener(ExecutionResultListener executionResultListener) {
        this.executionResultListener = executionResultListener;
    }
}

