/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.Row;
import org.qamatic.mintleaf.core.BinaryDataIterable;

public class FixedLengthRecordFile<T extends Row>
implements BinaryDataIterable {
    private int recordSize;
    private File filePath;
    private RandomAccessFile reader;
    private int recordNumber;
    private long offset;

    public FixedLengthRecordFile(File filePath, int recordSize) {
        this.filePath = filePath;
        this.recordSize = recordSize;
        this.offset = 0L;
    }

    public FixedLengthRecordFile(File filePath) {
        this.filePath = filePath;
        this.recordSize = 1;
    }

    private RandomAccessFile getReader() throws MintleafException {
        if (this.reader == null) {
            try {
                this.reader = new RandomAccessFile(this.filePath, "r");
            }
            catch (IOException e) {
                throw new MintleafException(e);
            }
        }
        return this.reader;
    }

    @Override
    public long getCurrentPos() throws MintleafException {
        try {
            return this.getReader().getFilePointer();
        }
        catch (IOException e) {
            throw new MintleafException(e);
        }
        catch (MintleafException e) {
            throw new MintleafException(e);
        }
    }

    @Override
    public BinaryDataIterable recordAt(int recordNumber) throws MintleafException {
        this.recordNumber = recordNumber - 1;
        return this;
    }

    @Override
    public BinaryDataIterable recordSize(int recordSize) throws MintleafException {
        this.recordSize = recordSize;
        return this;
    }

    @Override
    public BinaryDataIterable reset() throws MintleafException {
        return this.reset(0L);
    }

    @Override
    public BinaryDataIterable reset(long bytesPos) throws MintleafException {
        try {
            this.recordNumber = 0;
            this.getReader().seek(bytesPos);
            this.offset = this.getCurrentPos();
        }
        catch (IOException e) {
            throw new MintleafException(e);
        }
        return this;
    }

    @Override
    public Iterator<byte[]> iterator() {
        try {
            return new BinaryFileIterator(this.getReader(), this.recordSize, this.recordNumber, this.offset);
        }
        catch (MintleafException e) {
            MintleafException.throwException(e);
            return null;
        }
    }

    @Override
    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                MintleafException.throwException(e);
            }
        }
    }

    private static final class BinaryFileIterator
    implements Iterator<byte[]> {
        private final RandomAccessFile file;
        private final int recordSize;
        private final byte[] chunk;
        private int currentRecordIndex;
        private long offset;
        private long fileLength = -1L;

        public BinaryFileIterator(RandomAccessFile file, int recordSize, int startAt, long offset) {
            this.file = file;
            this.recordSize = recordSize;
            this.currentRecordIndex = startAt;
            this.offset = offset;
            this.chunk = new byte[recordSize];
        }

        private long getFileLength() throws MintleafException {
            if (this.fileLength == -1L) {
                try {
                    this.fileLength = this.file.length();
                }
                catch (IOException e) {
                    throw new MintleafException(e);
                }
            }
            return this.fileLength;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.offset + (long)(this.recordSize * (this.currentRecordIndex + 1)) <= this.getFileLength();
            }
            catch (MintleafException e) {
                MintleafException.throwException(e);
                return false;
            }
        }

        public void moveToCurrent() throws MintleafException {
            try {
                this.file.seek(this.offset + (long)(this.currentRecordIndex * this.recordSize));
            }
            catch (IOException e) {
                throw new MintleafException(e);
            }
        }

        @Override
        public byte[] next() {
            try {
                this.moveToCurrent();
                this.file.readFully(this.chunk, 0, this.recordSize);
                ++this.currentRecordIndex;
            }
            catch (MintleafException e) {
                MintleafException.throwException(e);
            }
            catch (IOException e) {
                MintleafException.throwException(e);
            }
            return this.chunk;
        }
    }
}

