/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core;

import org.qamatic.mintleaf.ConnectionContext;
import org.qamatic.mintleaf.Executable;
import org.qamatic.mintleaf.ExecutionResultListener;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.ParameterBinding;
import org.qamatic.mintleaf.SqlResultSet;
import org.qamatic.mintleaf.core.ExecuteQuery;
import org.qamatic.mintleaf.core.SelectQuery;

public class FluentJdbc {
    private static final MintleafLogger logger = MintleafLogger.getLogger(FluentJdbc.class);

    public static final class Builder {
        private String sql;
        private ParameterBinding parameterBinding;
        private ConnectionContext connectionContext;
        private ExecutionResultListener executionResultListener;

        public Builder(ConnectionContext connectionContext) {
            this.connectionContext = connectionContext;
        }

        public Builder withSql(String sql) {
            this.sql = sql;
            return this;
        }

        public Builder withParamValues(ParameterBinding parameterBinding) {
            this.parameterBinding = parameterBinding;
            return this;
        }

        public Builder withParamValues(Object[] parameterValues) {
            this.parameterBinding = parameterSets -> {
                for (int i = 0; i < parameterValues.length; ++i) {
                    parameterSets.setObject(i + 1, parameterValues[i]);
                }
            };
            return this;
        }

        public Builder withListener(ExecutionResultListener executionResultListener) throws MintleafException {
            this.executionResultListener = executionResultListener;
            return this;
        }

        public Executable<int[]> buildExecute() {
            try {
                ExecuteQuery query = new ExecuteQuery(this.connectionContext, this.sql, this.parameterBinding);
                query.setExecutionResultListener(this.executionResultListener);
                return query;
            }
            catch (Exception e) {
                MintleafException.throwException(e.getMessage());
                return null;
            }
        }

        public SqlResultSet buildSelect() {
            try {
                return new SelectQuery(this.connectionContext, this.sql, this.parameterBinding).execute();
            }
            catch (Exception e) {
                MintleafException.throwException(e.getMessage());
                return null;
            }
        }
    }
}

