/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core;

import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.qamatic.mintleaf.Column;
import org.qamatic.mintleaf.MetaDataCollection;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.Row;

public class InMemoryRow
implements Row {
    private MetaDataCollection metaDataCollection;
    private List<Object> rowValues = new ArrayList<Object>();

    public InMemoryRow() {
    }

    public InMemoryRow(MetaDataCollection metaDataCollection) {
        this.metaDataCollection = metaDataCollection;
    }

    @Override
    public Object getValue(int columnIndex) throws MintleafException {
        return this.rowValues.get(columnIndex);
    }

    @Override
    public MetaDataCollection getMetaData() throws MintleafException {
        return this.metaDataCollection;
    }

    @Override
    public void setMetaData(MetaDataCollection metaDataCollection) {
        this.metaDataCollection = metaDataCollection;
    }

    @Override
    public void setValue(int columnIndex, Object value) {
        this.getValues().add(value);
    }

    @Override
    public void setValue(int columnIndex, byte[] value, Charset charset) {
        this.setValue(columnIndex, new String(value, charset).trim());
    }

    @Override
    public void setValues(byte[] byteRecord, Charset charset) {
        int bstart = 0;
        try {
            if (this.getMetaData() == null) {
                MintleafException.throwException("metadata must be set on the object before calling this method");
            }
            for (int i = 0; i < this.getMetaData().getColumnCount(); ++i) {
                Column c = this.getMetaData().getColumn(i);
                byte[] bytes = Arrays.copyOfRange(byteRecord, bstart, bstart + c.getColumnSize());
                bstart += bytes.length;
                this.setValue(i, bytes, charset);
            }
        }
        catch (SQLException e) {
            MintleafException.throwException(e);
        }
        catch (MintleafException e) {
            MintleafException.throwException(e);
        }
    }

    public List<Object> getValues() {
        return this.rowValues;
    }
}

